/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.text;

import org.codelibs.core.misc.AssertionUtil;

public class Tokenizer {
    public static final int TT_EOF = -1;
    public static final int TT_QUOTE = 39;
    public static final int TT_WORD = -3;
    private static final int TT_NOTHING = -4;
    private static final int NEED_CHAR = Integer.MAX_VALUE;
    private static final int QUOTE = 39;
    private static final byte CT_WHITESPACE = 1;
    private static final byte CT_ALPHA = 4;
    private final byte[] ctype;
    private static byte[] defaultCtype = new byte[256];
    private final String str;
    private int colno = 0;
    private int ttype = -4;
    private String sval;
    private char[] buf = new char[20];
    private int peekc = Integer.MAX_VALUE;
    private byte peekct = 0;

    public Tokenizer(String str) {
        this(str, defaultCtype);
    }

    public Tokenizer(String str, byte[] ctype) {
        AssertionUtil.assertArgumentNotNull("str", str);
        AssertionUtil.assertArgumentNotEmpty("ctype", ctype);
        this.str = str;
        this.ctype = ctype;
    }

    protected static void setup(byte[] ctype2) {
        Tokenizer.wordChars(ctype2, 97, 122);
        Tokenizer.wordChars(ctype2, 65, 90);
        Tokenizer.wordChars(ctype2, 48, 57);
        Tokenizer.wordChar(ctype2, 64);
        Tokenizer.wordChar(ctype2, 124);
        Tokenizer.wordChar(ctype2, 95);
        Tokenizer.wordChar(ctype2, 63);
        Tokenizer.wordChar(ctype2, 62);
        Tokenizer.wordChar(ctype2, 61);
        Tokenizer.wordChar(ctype2, 33);
        Tokenizer.wordChar(ctype2, 60);
        Tokenizer.wordChar(ctype2, 34);
        Tokenizer.wordChar(ctype2, 126);
        Tokenizer.wordChar(ctype2, 42);
        Tokenizer.wordChar(ctype2, 46);
        Tokenizer.whitespaceChars(ctype2, 0, 32);
    }

    protected static void wordChars(byte[] ctype2, int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= ctype2.length) {
            hi = ctype2.length - 1;
        }
        while (low <= hi) {
            int n = low++;
            ctype2[n] = (byte)(ctype2[n] | 4);
        }
    }

    protected static void wordChar(byte[] ctype2, int val) {
        int n = val;
        ctype2[n] = (byte)(ctype2[n] | 4);
    }

    protected static void whitespaceChars(byte[] ctype2, int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= ctype2.length) {
            hi = ctype2.length - 1;
        }
        while (low <= hi) {
            ctype2[low++] = 1;
        }
    }

    protected static void ordinaryChar(byte[] ctype2, int ch) {
        if (ch >= 0 && ch < ctype2.length) {
            ctype2[ch] = 0;
        }
    }

    public String getStringValue() {
        return this.sval;
    }

    public int nextToken() {
        this.initVal();
        if (this.processEOF()) {
            return this.ttype;
        }
        if (this.processWhitespace()) {
            return this.ttype;
        }
        if (this.processWord()) {
            return this.ttype;
        }
        if (this.processQuote()) {
            return this.ttype;
        }
        if (this.processOrdinary()) {
            return this.ttype;
        }
        this.ttype = this.peekc;
        return this.ttype;
    }

    public String getReadString() {
        return this.str.substring(0, this.colno - 1);
    }

    private int read() {
        if (this.colno >= this.str.length()) {
            return -1;
        }
        return this.str.charAt(this.colno++);
    }

    private void initVal() {
        this.sval = null;
    }

    private boolean processEOF() {
        if (this.peekc < 0) {
            this.ttype = -1;
            return true;
        }
        if (this.peekc == Integer.MAX_VALUE) {
            this.peekc = this.read();
            if (this.peekc < 0) {
                this.ttype = -1;
                return true;
            }
        }
        return false;
    }

    private boolean processWhitespace() {
        this.peekct = (byte)(this.peekc < 256 ? this.ctype[this.peekc] : 4);
        while ((this.peekct & 1) != 0) {
            if (this.peekc == 13) {
                this.peekc = this.read();
                if (this.peekc == 10) {
                    this.peekc = this.read();
                }
            } else {
                this.peekc = this.read();
            }
            if (this.peekc < 0) {
                this.ttype = -1;
                return true;
            }
            this.peekct = (byte)(this.peekc < 256 ? this.ctype[this.peekc] : 4);
        }
        return false;
    }

    private boolean processWord() {
        if ((this.peekct & 4) != 0) {
            int i = 0;
            do {
                if (i >= this.buf.length) {
                    char[] nb = new char[this.buf.length * 2];
                    System.arraycopy(this.buf, 0, nb, 0, this.buf.length);
                    this.buf = nb;
                }
                this.buf[i++] = (char)this.peekc;
                this.peekc = this.read();
                int n = this.peekc < 0 ? 1 : (this.peekct = this.peekc < 256 ? this.ctype[this.peekc] : 4);
            } while ((this.peekct & 4) != 0);
            this.sval = String.copyValueOf(this.buf, 0, i);
            this.ttype = -3;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processQuote() {
        int d;
        if (this.peekc != 39) {
            return false;
        }
        this.ttype = 39;
        int i = 0;
        int c = d = this.read();
        while (d >= 0) {
            block6: {
                if (d == 39) {
                    int d2 = this.read();
                    if (d2 == 39) {
                        c = 39;
                        break block6;
                    } else {
                        d = d2;
                        break;
                    }
                }
                c = d;
            }
            if (i >= this.buf.length) {
                char[] nb = new char[this.buf.length * 2];
                System.arraycopy(this.buf, 0, nb, 0, this.buf.length);
                this.buf = nb;
            }
            this.buf[i++] = (char)c;
            d = this.read();
        }
        this.peekc = d;
        this.sval = String.copyValueOf(this.buf, 0, i);
        return true;
    }

    private boolean processOrdinary() {
        if (this.peekct == 0) {
            this.ttype = this.peekc;
            this.peekc = this.read();
            this.peekct = this.peekc < 0 ? 1 : (this.peekc < 256 ? this.ctype[this.peekc] : 4);
            return true;
        }
        return false;
    }

    static {
        Tokenizer.setup(defaultCtype);
    }
}

