/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.text;

public class JsonUtil {
    protected JsonUtil() {
    }

    public static String escape(String value) {
        if (value == null) {
            return null;
        }
        int len = value.length();
        StringBuilder buf = new StringBuilder(len * 2);
        block9: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    buf.append('\\');
                    buf.append(c);
                    continue block9;
                }
                case '/': {
                    buf.append('\\');
                    buf.append(c);
                    continue block9;
                }
                case '\b': {
                    buf.append("\\b");
                    continue block9;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block9;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block9;
                }
                case '\f': {
                    buf.append("\\f");
                    continue block9;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String hex = Integer.toHexString(c);
                        buf.append("\\u");
                        for (int j = 0; j < 4 - hex.length(); ++j) {
                            buf.append('0');
                        }
                        buf.append(hex);
                        continue block9;
                    }
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }
}

