/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.text;

import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.codelibs.core.misc.AssertionUtil;
import org.codelibs.core.misc.LocaleUtil;
import org.codelibs.core.text.DecimalFormatSymbolsUtil;

public abstract class DecimalFormatUtil {
    public static String normalize(String s) {
        return DecimalFormatUtil.normalize(s, LocaleUtil.getDefault());
    }

    public static String normalize(String s, Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        if (s == null) {
            return null;
        }
        DecimalFormatSymbols symbols = DecimalFormatSymbolsUtil.getDecimalFormatSymbols(locale);
        char decimalSep = symbols.getDecimalSeparator();
        char groupingSep = symbols.getGroupingSeparator();
        StringBuilder buf = new StringBuilder(20);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == groupingSep) continue;
            if (c == decimalSep) {
                c = '.';
            }
            buf.append(c);
        }
        return buf.toString();
    }
}

