/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.stream;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class StreamUtil {
    private StreamUtil() {
    }

    @SafeVarargs
    public static <T> StreamOf<T> stream(T ... values) {
        return new StreamOf(() -> values != null ? Arrays.stream(values) : Collections.emptyList().stream());
    }

    public static StreamOf<String> split(String value, String regex) {
        return StreamUtil.stream(value == null ? null : value.split(regex));
    }

    public static <K, V> StreamOf<Map.Entry<K, V>> stream(Map<K, V> map) {
        return new StreamOf<Map.Entry<K, V>>(() -> map != null ? map.entrySet().stream() : Collections.emptyMap().entrySet().stream());
    }

    public static class StreamOf<T> {
        private final Supplier<Stream<T>> supplier;

        public StreamOf(Supplier<Stream<T>> supplier) {
            this.supplier = supplier;
        }

        public void of(Consumer<Stream<T>> stream) {
            try (Stream<T> s = this.supplier.get();){
                stream.accept(s);
            }
        }

        public <R> R get(Function<Stream<T>, R> stream) {
            try (Stream<T> s = this.supplier.get();){
                R r = stream.apply(s);
                return r;
            }
        }
    }
}

