/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.codelibs.core.exception.SQLRuntimeException;
import org.codelibs.core.log.Logger;
import org.codelibs.core.misc.AssertionUtil;

public abstract class StatementUtil {
    private static final Logger logger = Logger.getLogger(StatementUtil.class);

    public static boolean execute(Statement statement, String sql) {
        AssertionUtil.assertArgumentNotNull("statement", statement);
        AssertionUtil.assertArgumentNotEmpty("sql", sql);
        try {
            return statement.execute(sql);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static void setFetchSize(Statement statement, int fetchSize) {
        AssertionUtil.assertArgumentNotNull("statement", statement);
        try {
            statement.setFetchSize(fetchSize);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static void setMaxRows(Statement statement, int maxRows) {
        AssertionUtil.assertArgumentNotNull("statement", statement);
        try {
            statement.setMaxRows(maxRows);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static void setQueryTimeout(Statement statement, int queryTimeout) {
        AssertionUtil.assertArgumentNotNull("statement", statement);
        try {
            statement.setQueryTimeout(queryTimeout);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static void close(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            logger.log(Logger.format("ECL0017", e.getMessage()), e);
        }
    }

    public static ResultSet getResultSet(Statement statement) {
        AssertionUtil.assertArgumentNotNull("statement", statement);
        try {
            return statement.getResultSet();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static int getUpdateCount(Statement statement) {
        AssertionUtil.assertArgumentNotNull("statement", statement);
        try {
            return statement.getUpdateCount();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }
}

