/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.codelibs.core.exception.SQLRuntimeException;
import org.codelibs.core.misc.AssertionUtil;

public abstract class PreparedStatementUtil {
    public static ResultSet executeQuery(PreparedStatement ps) throws SQLRuntimeException {
        AssertionUtil.assertArgumentNotNull("ps", ps);
        try {
            return ps.executeQuery();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static int executeUpdate(PreparedStatement ps) throws SQLRuntimeException {
        AssertionUtil.assertArgumentNotNull("ps", ps);
        try {
            return ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static boolean execute(PreparedStatement ps) throws SQLRuntimeException {
        AssertionUtil.assertArgumentNotNull("ps", ps);
        try {
            return ps.execute();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static int[] executeBatch(PreparedStatement ps) throws SQLRuntimeException {
        AssertionUtil.assertArgumentNotNull("ps", ps);
        try {
            return ps.executeBatch();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static void addBatch(PreparedStatement ps) throws SQLRuntimeException {
        AssertionUtil.assertArgumentNotNull("ps", ps);
        try {
            ps.addBatch();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }
}

