/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.sql;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import org.codelibs.core.exception.SQLRuntimeException;
import org.codelibs.core.lang.ClassUtil;
import org.codelibs.core.misc.AssertionUtil;

public abstract class DriverManagerUtil {
    public static void registerDriver(String driverClassName) {
        AssertionUtil.assertArgumentNotEmpty("driverClassName", driverClassName);
        Class<Driver> clazz = ClassUtil.forName(driverClassName);
        DriverManagerUtil.registerDriver(clazz);
    }

    public static void registerDriver(Class<Driver> driverClass) {
        AssertionUtil.assertArgumentNotNull("driverClass", driverClass);
        DriverManagerUtil.registerDriver(ClassUtil.newInstance(driverClass));
    }

    public static void registerDriver(Driver driver) {
        AssertionUtil.assertArgumentNotNull("driver", driver);
        try {
            DriverManager.registerDriver(driver);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    public static void deregisterDriver(Driver driver) {
        AssertionUtil.assertArgumentNotNull("driver", driver);
        try {
            DriverManager.deregisterDriver(driver);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    public static synchronized void deregisterAllDrivers() {
        Enumeration<Driver> e = DriverManager.getDrivers();
        while (e.hasMoreElements()) {
            DriverManagerUtil.deregisterDriver(e.nextElement());
        }
    }
}

