/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.security;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.codelibs.core.exception.ClIllegalStateException;
import org.codelibs.core.exception.NoSuchAlgorithmRuntimeException;
import org.codelibs.core.misc.AssertionUtil;

public abstract class MessageDigestUtil {
    public static MessageDigest getInstance(String algorithm) {
        AssertionUtil.assertArgumentNotEmpty("algorithm", algorithm);
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmRuntimeException(e);
        }
    }

    public static String digest(String algorithm, String text) {
        AssertionUtil.assertArgumentNotEmpty("algorithm", algorithm);
        if (text == null) {
            return null;
        }
        MessageDigest msgDigest = MessageDigestUtil.getInstance(algorithm);
        try {
            msgDigest.update(text.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ClIllegalStateException(e);
        }
        byte[] digest = msgDigest.digest();
        StringBuilder buffer = new StringBuilder(200);
        for (byte element : digest) {
            String tmp = Integer.toHexString(element & 0xFF);
            if (tmp.length() == 1) {
                buffer.append('0').append(tmp);
                continue;
            }
            buffer.append(tmp);
        }
        return buffer.toString();
    }
}

