/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import org.codelibs.core.lang.StringUtil;

public abstract class UuidUtil {
    private static final byte[] DEFAULT_ADDRESS = new byte[]{127, 0, 0, 1};
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final String BASE = StringUtil.toHex(UuidUtil.getAddress()) + StringUtil.toHex(System.identityHashCode(RANDOM));

    public static String create() {
        StringBuilder buf = new StringBuilder(BASE.length() * 2);
        buf.append(BASE);
        int lowTime = (int)(System.currentTimeMillis() >> 32);
        StringUtil.appendHex(buf, lowTime);
        StringUtil.appendHex(buf, RANDOM.nextInt());
        return buf.toString();
    }

    private static byte[] getAddress() {
        try {
            return InetAddress.getLocalHost().getAddress();
        }
        catch (UnknownHostException ignore) {
            return DEFAULT_ADDRESS;
        }
    }
}

