/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.net;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import org.codelibs.core.collection.ArrayUtil;
import org.codelibs.core.collection.CollectionsUtil;
import org.codelibs.core.exception.ClRuntimeException;
import org.codelibs.core.exception.IORuntimeException;
import org.codelibs.core.misc.AssertionUtil;

public abstract class URLUtil {
    protected static final Map<String, String> CANONICAL_PROTOCOLS = CollectionsUtil.newHashMap();

    public static InputStream openStream(URL url) {
        AssertionUtil.assertArgumentNotNull("url", url);
        try {
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static URLConnection openConnection(URL url) {
        AssertionUtil.assertArgumentNotNull("url", url);
        try {
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static URL create(String spec) {
        AssertionUtil.assertArgumentNotEmpty("spec", spec);
        try {
            return new URL(spec);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static URL create(URL context, String spec) {
        AssertionUtil.assertArgumentNotNull("context", context);
        AssertionUtil.assertArgumentNotEmpty("spec", spec);
        try {
            return new URL(context, spec);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static String encode(String s, String enc) {
        AssertionUtil.assertArgumentNotEmpty("s", s);
        AssertionUtil.assertArgumentNotEmpty("enc", enc);
        try {
            return URLEncoder.encode(s, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new IORuntimeException(e);
        }
    }

    public static String decode(String s, String enc) {
        AssertionUtil.assertArgumentNotEmpty("s", s);
        AssertionUtil.assertArgumentNotEmpty("enc", enc);
        try {
            return URLDecoder.decode(s, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new IORuntimeException(e);
        }
    }

    public static String toCanonicalProtocol(String protocol) {
        AssertionUtil.assertArgumentNotEmpty("protocol", protocol);
        String canonicalProtocol = CANONICAL_PROTOCOLS.get(protocol);
        if (canonicalProtocol != null) {
            return canonicalProtocol;
        }
        return protocol;
    }

    public static File toFile(URL fileUrl) {
        AssertionUtil.assertArgumentNotNull("fileUrl", fileUrl);
        try {
            String path = URLDecoder.decode(fileUrl.getPath(), "UTF-8");
            return new File(path).getAbsoluteFile();
        }
        catch (Exception e) {
            throw new ClRuntimeException("ECL0091", ArrayUtil.asArray(fileUrl), e);
        }
    }

    static {
        CANONICAL_PROTOCOLS.put("wsjar", "jar");
        CANONICAL_PROTOCOLS.put("vfsfile", "file");
    }
}

