/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import org.codelibs.core.exception.IORuntimeException;
import org.codelibs.core.io.CloseableUtil;
import org.codelibs.core.io.ResourceUtil;
import org.codelibs.core.misc.AssertionUtil;

public abstract class MimeTypeUtil {
    public static String guessContentType(String path) {
        AssertionUtil.assertArgumentNotEmpty("path", path);
        InputStream is = ResourceUtil.getResourceAsStream(path);
        try {
            String mimetype = URLConnection.guessContentTypeFromStream(is);
            if (mimetype != null) {
                String string = mimetype;
                return string;
            }
            String string = URLConnection.guessContentTypeFromName(path);
            return string;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            CloseableUtil.close(is);
        }
    }
}

