/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.misc;

import java.util.Locale;
import java.util.function.Supplier;

public abstract class LocaleUtil {
    private static Supplier<Locale> defaultLocaleSupplier;

    public static Locale getLocale(String localeStr) {
        Locale locale = LocaleUtil.getDefault();
        if (localeStr != null) {
            int index = localeStr.indexOf(95);
            if (index < 0) {
                locale = new Locale(localeStr);
            } else {
                String language = localeStr.substring(0, index);
                String country = localeStr.substring(index + 1);
                locale = new Locale(language, country);
            }
        }
        return locale;
    }

    public static Locale getDefault() {
        if (defaultLocaleSupplier != null) {
            return defaultLocaleSupplier.get();
        }
        return Locale.ENGLISH;
    }

    public static void setDefault(Supplier<Locale> localeSupplier) {
        defaultLocaleSupplier = localeSupplier;
    }
}

