/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.misc;

import java.beans.Introspector;
import java.util.Deque;
import org.codelibs.core.collection.CollectionsUtil;
import org.codelibs.core.misc.AssertionUtil;
import org.codelibs.core.misc.Disposable;

public abstract class DisposableUtil {
    protected static final Deque<Disposable> disposables = CollectionsUtil.newLinkedList();

    public static synchronized void add(Disposable disposable) {
        AssertionUtil.assertArgumentNotNull("disposable", disposable);
        disposables.addLast(disposable);
    }

    public static synchronized void addFirst(Disposable disposable) {
        AssertionUtil.assertArgumentNotNull("disposable", disposable);
        disposables.addFirst(disposable);
    }

    public static synchronized void remove(Disposable disposable) {
        AssertionUtil.assertArgumentNotNull("disposable", disposable);
        disposables.remove(disposable);
    }

    public static synchronized void dispose() {
        while (!disposables.isEmpty()) {
            Disposable disposable = disposables.removeLast();
            try {
                disposable.dispose();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        disposables.clear();
        Introspector.flushCaches();
    }
}

