/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.misc;

import java.util.Collection;
import java.util.Map;
import org.codelibs.core.collection.ArrayUtil;
import org.codelibs.core.exception.ClIllegalArgumentException;
import org.codelibs.core.exception.ClIllegalStateException;
import org.codelibs.core.exception.ClIndexOutOfBoundsException;
import org.codelibs.core.exception.EmptyArgumentException;
import org.codelibs.core.exception.NullArgumentException;
import org.codelibs.core.lang.StringUtil;

public abstract class AssertionUtil {
    public static void assertArgumentNotNull(String argName, Object argValue) {
        if (argValue == null) {
            throw new NullArgumentException(argName);
        }
    }

    public static void assertArgumentNotEmpty(String argName, String argValue) {
        if (StringUtil.isEmpty(argValue)) {
            throw new EmptyArgumentException(argName, "ECL0010", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, CharSequence argValue) {
        if (argValue == null || argValue.length() == 0) {
            throw new EmptyArgumentException(argName, "ECL0010", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, Object[] argValue) {
        if (ArrayUtil.isEmpty(argValue)) {
            throw new EmptyArgumentException(argName, "ECL0011", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, boolean[] argValue) {
        if (ArrayUtil.isEmpty(argValue)) {
            throw new EmptyArgumentException(argName, "ECL0011", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, byte[] argValue) {
        if (ArrayUtil.isEmpty(argValue)) {
            throw new EmptyArgumentException(argName, "ECL0011", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, short[] argValue) {
        if (ArrayUtil.isEmpty(argValue)) {
            throw new EmptyArgumentException(argName, "ECL0011", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, int[] argValue) {
        if (ArrayUtil.isEmpty(argValue)) {
            throw new EmptyArgumentException(argName, "ECL0011", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, long[] argValue) {
        if (ArrayUtil.isEmpty(argValue)) {
            throw new EmptyArgumentException(argName, "ECL0011", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, float[] argValue) {
        if (ArrayUtil.isEmpty(argValue)) {
            throw new EmptyArgumentException(argName, "ECL0011", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, double[] argValue) {
        if (ArrayUtil.isEmpty(argValue)) {
            throw new EmptyArgumentException(argName, "ECL0011", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, char[] argValue) {
        if (ArrayUtil.isEmpty(argValue)) {
            throw new EmptyArgumentException(argName, "ECL0011", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, Collection<?> argValue) {
        if (argValue == null || argValue.isEmpty()) {
            throw new EmptyArgumentException(argName, "ECL0012", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentNotEmpty(String argName, Map<?, ?> argValue) {
        if (argValue == null || argValue.isEmpty()) {
            throw new EmptyArgumentException(argName, "ECL0013", ArrayUtil.asArray(argName));
        }
    }

    public static void assertArgumentArrayIndex(String argName, int argValue, int arraySize) {
        if (argValue < 0) {
            throw new ClIllegalArgumentException(argName, "ECL0014", ArrayUtil.asArray(argName));
        }
        if (argValue >= arraySize) {
            throw new ClIllegalArgumentException(argName, "ECL0015", ArrayUtil.asArray(argName, arraySize));
        }
    }

    public static void assertArgument(String argName, boolean expression, String description) {
        if (!expression) {
            throw new ClIllegalArgumentException(argName, "ECL0009", ArrayUtil.asArray(argName, description));
        }
    }

    public static void assertState(boolean expression, String description) {
        if (!expression) {
            throw new ClIllegalStateException(description);
        }
    }

    public static void assertIndex(boolean expression, String description) {
        if (!expression) {
            throw new ClIndexOutOfBoundsException(description);
        }
    }
}

