/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.log;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.codelibs.core.log.LoggerAdapter;

class JulLoggerAdapter
implements LoggerAdapter {
    protected final String sourceClass;
    protected final Logger logger;

    public JulLoggerAdapter(Class<?> clazz) {
        this.sourceClass = clazz.getName();
        this.logger = Logger.getLogger(clazz.getName());
    }

    @Override
    public boolean isFatalEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public void fatal(String message) {
        this.logger.logp(Level.SEVERE, this.sourceClass, null, message);
    }

    @Override
    public void fatal(String message, Throwable t) {
        this.logger.logp(Level.SEVERE, this.sourceClass, null, message, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public void error(String message) {
        this.logger.logp(Level.SEVERE, this.sourceClass, null, message);
    }

    @Override
    public void error(String message, Throwable t) {
        this.logger.logp(Level.SEVERE, this.sourceClass, null, message, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public void warn(String message) {
        this.logger.logp(Level.WARNING, this.sourceClass, null, message);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.logger.logp(Level.WARNING, this.sourceClass, null, message, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public void info(String message) {
        this.logger.logp(Level.INFO, this.sourceClass, null, message);
    }

    @Override
    public void info(String message, Throwable t) {
        this.logger.logp(Level.INFO, this.sourceClass, null, message, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public void debug(String message) {
        this.logger.logp(Level.FINE, this.sourceClass, null, message);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.logger.logp(Level.FINE, this.sourceClass, null, message, t);
    }
}

