/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.lang;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codelibs.core.collection.CollectionsUtil;
import org.codelibs.core.misc.AssertionUtil;

public abstract class GenericsUtil {
    public static boolean isTypeOf(Type type, Class<?> clazz) {
        AssertionUtil.assertArgumentNotNull("type", type);
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        if (type instanceof Class) {
            return clazz.isAssignableFrom((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            return GenericsUtil.isTypeOf(parameterizedType.getRawType(), clazz);
        }
        return false;
    }

    public static Class<?> getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)Class.class.cast(type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            return GenericsUtil.getRawClass(parameterizedType.getRawType());
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)WildcardType.class.cast(type);
            Type[] types = wildcardType.getUpperBounds();
            return GenericsUtil.getRawClass(types[0]);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)GenericArrayType.class.cast(type);
            Class<?> rawClass = GenericsUtil.getRawClass(genericArrayType.getGenericComponentType());
            return Array.newInstance(rawClass, 0).getClass();
        }
        return null;
    }

    public static Type[] getGenericParameters(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)ParameterizedType.class.cast(type)).getActualTypeArguments();
        }
        if (type instanceof GenericArrayType) {
            return GenericsUtil.getGenericParameters(((GenericArrayType)GenericArrayType.class.cast(type)).getGenericComponentType());
        }
        return null;
    }

    public static Type getGenericParameter(Type type, int index) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        Type[] genericParameter = GenericsUtil.getGenericParameters(type);
        if (genericParameter == null) {
            return null;
        }
        AssertionUtil.assertArgumentArrayIndex("index", index, genericParameter.length);
        return genericParameter[index];
    }

    public static Type getElementTypeOfArray(Type type) {
        if (!(type instanceof GenericArrayType)) {
            return null;
        }
        return ((GenericArrayType)GenericArrayType.class.cast(type)).getGenericComponentType();
    }

    public static Type getElementTypeOfCollection(Type type) {
        if (!GenericsUtil.isTypeOf(type, Collection.class)) {
            return null;
        }
        return GenericsUtil.getGenericParameter(type, 0);
    }

    public static Type getElementTypeOfList(Type type) {
        if (!GenericsUtil.isTypeOf(type, List.class)) {
            return null;
        }
        return GenericsUtil.getGenericParameter(type, 0);
    }

    public static Type getElementTypeOfSet(Type type) {
        if (!GenericsUtil.isTypeOf(type, Set.class)) {
            return null;
        }
        return GenericsUtil.getGenericParameter(type, 0);
    }

    public static Type getKeyTypeOfMap(Type type) {
        if (!GenericsUtil.isTypeOf(type, Map.class)) {
            return null;
        }
        return GenericsUtil.getGenericParameter(type, 0);
    }

    public static Type getValueTypeOfMap(Type type) {
        if (!GenericsUtil.isTypeOf(type, Map.class)) {
            return null;
        }
        return GenericsUtil.getGenericParameter(type, 1);
    }

    public static Map<TypeVariable<?>, Type> getTypeVariableMap(Class<?> clazz) {
        TypeVariable<Class<?>>[] typeParameters;
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        LinkedHashMap<TypeVariable<?>, Type> map = CollectionsUtil.newLinkedHashMap();
        for (TypeVariable<Class<?>> typeParameter : typeParameters = clazz.getTypeParameters()) {
            map.put(typeParameter, GenericsUtil.getActualClass(typeParameter.getBounds()[0], map));
        }
        Class<?> superClass = clazz.getSuperclass();
        Type superClassType = clazz.getGenericSuperclass();
        if (superClass != null) {
            GenericsUtil.gatherTypeVariables(superClass, superClassType, map);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        Type[] interfaceTypes = clazz.getGenericInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            GenericsUtil.gatherTypeVariables(interfaces[i], interfaceTypes[i], map);
        }
        return map;
    }

    protected static void gatherTypeVariables(Class<?> clazz, Type type, Map<TypeVariable<?>, Type> map) {
        if (clazz == null) {
            return;
        }
        GenericsUtil.gatherTypeVariables(type, map);
        Class<?> superClass = clazz.getSuperclass();
        Type superClassType = clazz.getGenericSuperclass();
        if (superClass != null) {
            GenericsUtil.gatherTypeVariables(superClass, superClassType, map);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        Type[] interfaceTypes = clazz.getGenericInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            GenericsUtil.gatherTypeVariables(interfaces[i], interfaceTypes[i], map);
        }
    }

    protected static void gatherTypeVariables(Type type, Map<TypeVariable<?>, Type> map) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            TypeVariable<?>[] typeVariables = ((GenericDeclaration)GenericDeclaration.class.cast(parameterizedType.getRawType())).getTypeParameters();
            Type[] actualTypes = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < actualTypes.length; ++i) {
                map.put(typeVariables[i], actualTypes[i]);
            }
        }
    }

    public static Class<?> getActualClass(Type type, Map<TypeVariable<?>, Type> map) {
        if (type instanceof Class) {
            return (Class)Class.class.cast(type);
        }
        if (type instanceof ParameterizedType) {
            return GenericsUtil.getActualClass(((ParameterizedType)ParameterizedType.class.cast(type)).getRawType(), map);
        }
        if (type instanceof WildcardType) {
            return GenericsUtil.getActualClass(((WildcardType)WildcardType.class.cast(type)).getUpperBounds()[0], map);
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)TypeVariable.class.cast(type);
            if (map.containsKey(typeVariable)) {
                return GenericsUtil.getActualClass(map.get(typeVariable), map);
            }
            return GenericsUtil.getActualClass(typeVariable.getBounds()[0], map);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)GenericArrayType.class.cast(type);
            Class<?> componentClass = GenericsUtil.getActualClass(genericArrayType.getGenericComponentType(), map);
            return Array.newInstance(componentClass, 0).getClass();
        }
        return null;
    }

    public static Class<?> getActualElementClassOfArray(Type type, Map<TypeVariable<?>, Type> map) {
        if (!(type instanceof GenericArrayType)) {
            return null;
        }
        return GenericsUtil.getActualClass(((GenericArrayType)GenericArrayType.class.cast(type)).getGenericComponentType(), map);
    }

    public static Class<?> getActualElementClassOfCollection(Type type, Map<TypeVariable<?>, Type> map) {
        if (!GenericsUtil.isTypeOf(type, Collection.class)) {
            return null;
        }
        return GenericsUtil.getActualClass(GenericsUtil.getGenericParameter(type, 0), map);
    }

    public static Class<?> getActualElementClassOfList(Type type, Map<TypeVariable<?>, Type> map) {
        if (!GenericsUtil.isTypeOf(type, List.class)) {
            return null;
        }
        return GenericsUtil.getActualClass(GenericsUtil.getGenericParameter(type, 0), map);
    }

    public static Class<?> getActualElementClassOfSet(Type type, Map<TypeVariable<?>, Type> map) {
        if (!GenericsUtil.isTypeOf(type, Set.class)) {
            return null;
        }
        return GenericsUtil.getActualClass(GenericsUtil.getGenericParameter(type, 0), map);
    }

    public static Class<?> getActualKeyClassOfMap(Type type, Map<TypeVariable<?>, Type> map) {
        if (!GenericsUtil.isTypeOf(type, Map.class)) {
            return null;
        }
        return GenericsUtil.getActualClass(GenericsUtil.getGenericParameter(type, 0), map);
    }

    public static Class<?> getActualValueClassOfMap(Type type, Map<TypeVariable<?>, Type> map) {
        if (!GenericsUtil.isTypeOf(type, Map.class)) {
            return null;
        }
        return GenericsUtil.getActualClass(GenericsUtil.getGenericParameter(type, 1), map);
    }
}

