/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.codelibs.core.exception.IllegalAccessRuntimeException;
import org.codelibs.core.exception.InstantiationRuntimeException;
import org.codelibs.core.exception.InvocationTargetRuntimeException;
import org.codelibs.core.misc.AssertionUtil;

public abstract class ConstructorUtil {
    public static <T> T newInstance(Constructor<T> constructor, Object ... args) throws InstantiationRuntimeException, IllegalAccessRuntimeException {
        AssertionUtil.assertArgumentNotNull("constructor", constructor);
        try {
            return constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new InstantiationRuntimeException(constructor.getDeclaringClass(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException(constructor.getDeclaringClass(), e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetRuntimeException(constructor.getDeclaringClass(), e);
        }
    }

    public static boolean isPublic(Constructor<?> constructor) {
        AssertionUtil.assertArgumentNotNull("constructor", constructor);
        return Modifier.isPublic(constructor.getModifiers());
    }
}

