/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.lang;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import org.codelibs.core.collection.EnumerationIterator;
import org.codelibs.core.exception.ClIllegalStateException;
import org.codelibs.core.exception.ClassNotFoundRuntimeException;
import org.codelibs.core.exception.IORuntimeException;
import org.codelibs.core.lang.ClassLoaderIterator;
import org.codelibs.core.lang.ClassUtil;
import org.codelibs.core.lang.MethodUtil;
import org.codelibs.core.message.MessageFormatter;
import org.codelibs.core.misc.AssertionUtil;

public abstract class ClassLoaderUtil {
    private static final Method findLoadedClassMethod = ClassLoaderUtil.getFindLoadedClassMethod();
    private static final Method defineClassMethod = ClassLoaderUtil.getDefineClassMethod();
    private static final Method definePackageMethod = ClassLoaderUtil.getDefinePackageMethod();

    private static Method getFindLoadedClassMethod() {
        Method method = ClassUtil.getDeclaredMethod(ClassLoader.class, "findLoadedClass", String.class);
        method.setAccessible(true);
        return method;
    }

    private static Method getDefineClassMethod() {
        Method method = ClassUtil.getDeclaredMethod(ClassLoader.class, "defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        method.setAccessible(true);
        return method;
    }

    private static Method getDefinePackageMethod() {
        Method method = ClassUtil.getDeclaredMethod(ClassLoader.class, "definePackage", String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class);
        method.setAccessible(true);
        return method;
    }

    public static ClassLoader getClassLoader(Class<?> targetClass) {
        AssertionUtil.assertArgumentNotNull("targetClass", targetClass);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader;
        }
        ClassLoader targetClassLoader = targetClass.getClassLoader();
        ClassLoader thisClassLoader = ClassLoaderUtil.class.getClassLoader();
        if (targetClassLoader != null && thisClassLoader != null) {
            if (ClassLoaderUtil.isAncestor(thisClassLoader, targetClassLoader)) {
                return thisClassLoader;
            }
            return targetClassLoader;
        }
        if (targetClassLoader != null) {
            return targetClassLoader;
        }
        if (thisClassLoader != null) {
            return thisClassLoader;
        }
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        if (systemClassLoader != null) {
            return systemClassLoader;
        }
        throw new ClIllegalStateException(MessageFormatter.getMessage("ECL0001", "ClassLoader"));
    }

    protected static boolean isAncestor(ClassLoader cl, ClassLoader other) {
        for (ClassLoader loader : ClassLoaderIterator.iterable(cl)) {
            if (loader != other) continue;
            return true;
        }
        return false;
    }

    public static Iterator<URL> getResources(String name) {
        AssertionUtil.assertArgumentNotEmpty("name", name);
        return ClassLoaderUtil.getResources(Thread.currentThread().getContextClassLoader(), name);
    }

    public static Iterator<URL> getResources(Class<?> targetClass, String name) {
        AssertionUtil.assertArgumentNotNull("targetClass", targetClass);
        AssertionUtil.assertArgumentNotNull("name", name);
        return ClassLoaderUtil.getResources(ClassLoaderUtil.getClassLoader(targetClass), name);
    }

    public static Iterator<URL> getResources(ClassLoader loader, String name) {
        AssertionUtil.assertArgumentNotNull("loader", loader);
        AssertionUtil.assertArgumentNotEmpty("name", name);
        try {
            Enumeration<URL> e = loader.getResources(name);
            return new EnumerationIterator<URL>(e);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Class<?> findLoadedClass(ClassLoader classLoader, String className) {
        AssertionUtil.assertArgumentNotNull("classLoader", classLoader);
        AssertionUtil.assertArgumentNotEmpty("className", className);
        for (ClassLoader loader : ClassLoaderIterator.iterable(classLoader)) {
            Class clazz = (Class)MethodUtil.invoke(findLoadedClassMethod, loader, className);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    public static Class<?> defineClass(ClassLoader classLoader, String className, byte[] bytes, int offset, int length) {
        AssertionUtil.assertArgumentNotNull("classLoader", classLoader);
        AssertionUtil.assertArgumentNotEmpty("className", className);
        AssertionUtil.assertArgumentNotEmpty("bytes", bytes);
        return (Class)MethodUtil.invoke(defineClassMethod, classLoader, className, bytes, offset, length);
    }

    public static Package definePackage(ClassLoader classLoader, String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) {
        AssertionUtil.assertArgumentNotNull("classLoader", classLoader);
        AssertionUtil.assertArgumentNotEmpty("name", name);
        return (Package)MethodUtil.invoke(definePackageMethod, classLoader, name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    public static Class<?> loadClass(ClassLoader loader, String className) {
        AssertionUtil.assertArgumentNotNull("loader", loader);
        AssertionUtil.assertArgumentNotEmpty("className", className);
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundRuntimeException(e);
        }
    }
}

