/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.lang;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.codelibs.core.exception.ClUnsupportedOperationException;
import org.codelibs.core.misc.AssertionUtil;

public class ClassLoaderIterator
implements Iterator<ClassLoader> {
    protected ClassLoader classLoader;

    public static Iterable<ClassLoader> iterable(ClassLoader classLoader) {
        return () -> new ClassLoaderIterator(classLoader);
    }

    public ClassLoaderIterator(ClassLoader classLoader) {
        AssertionUtil.assertArgumentNotNull("classLoader", classLoader);
        this.classLoader = classLoader;
    }

    @Override
    public boolean hasNext() {
        return this.classLoader != null;
    }

    @Override
    public ClassLoader next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ClassLoader result = this.classLoader;
        this.classLoader = this.classLoader.getParent();
        return result;
    }

    @Override
    public void remove() {
        throw new ClUnsupportedOperationException("remove");
    }
}

