/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.lang;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.codelibs.core.exception.ClUnsupportedOperationException;
import org.codelibs.core.message.MessageFormatter;
import org.codelibs.core.misc.AssertionUtil;

public class ClassIterator
implements Iterator<Class<?>> {
    protected Class<?> clazz;
    protected final boolean includeObject;

    public static Iterable<Class<?>> iterable(Class<?> clazz) {
        return ClassIterator.iterable(clazz, true);
    }

    public static Iterable<Class<?>> iterable(Class<?> clazz, boolean includeObject) {
        return () -> new ClassIterator(clazz, includeObject);
    }

    public ClassIterator(Class<?> clazz) {
        this(clazz, true);
    }

    public ClassIterator(Class<?> clazz, boolean includeObject) {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        AssertionUtil.assertArgument("clazz", !clazz.isInterface(), MessageFormatter.getSimpleMessage("ECL0103", clazz));
        this.clazz = clazz;
        this.includeObject = includeObject;
    }

    @Override
    public boolean hasNext() {
        if (!this.includeObject && this.clazz == Object.class) {
            return false;
        }
        return this.clazz != null;
    }

    @Override
    public Class<?> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Class<?> result = this.clazz;
        this.clazz = this.clazz.getSuperclass();
        return result;
    }

    @Override
    public void remove() {
        throw new ClUnsupportedOperationException("remove");
    }
}

