/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.io;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.codelibs.core.collection.ArrayUtil;
import org.codelibs.core.collection.CollectionsUtil;
import org.codelibs.core.io.ClassHandler;
import org.codelibs.core.io.ClassTraversalUtil;
import org.codelibs.core.io.CloseableUtil;
import org.codelibs.core.io.FileUtil;
import org.codelibs.core.io.ResourceHandler;
import org.codelibs.core.io.ResourceTraversalUtil;
import org.codelibs.core.io.ResourceUtil;
import org.codelibs.core.io.Traverser;
import org.codelibs.core.jar.JarFileUtil;
import org.codelibs.core.lang.ClassLoaderUtil;
import org.codelibs.core.lang.ClassUtil;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.log.Logger;
import org.codelibs.core.misc.AssertionUtil;
import org.codelibs.core.net.URLUtil;
import org.codelibs.core.zip.ZipFileUtil;
import org.codelibs.core.zip.ZipInputStreamUtil;

public abstract class TraversalUtil {
    protected static final Traverser[] EMPTY_ARRAY = new Traverser[0];
    private static final Logger logger = Logger.getLogger(TraversalUtil.class);
    protected static final ConcurrentMap<String, TraverserFactory> traverserFactories = CollectionsUtil.newConcurrentHashMap();

    public static void addTraverserFactory(String protocol, TraverserFactory factory) {
        AssertionUtil.assertArgumentNotEmpty("protocol", protocol);
        AssertionUtil.assertArgumentNotNull("factory", factory);
        traverserFactories.put(protocol, factory);
    }

    public static Traverser getTraverser(Class<?> referenceClass) {
        AssertionUtil.assertArgumentNotNull("referenceClass", referenceClass);
        URL url = ResourceUtil.getResource(TraversalUtil.toClassFile(referenceClass.getName()));
        String[] path = referenceClass.getName().split("\\.");
        String baseUrl = url.toExternalForm();
        for (String element : path) {
            int pos = baseUrl.lastIndexOf(47);
            baseUrl = baseUrl.substring(0, pos);
        }
        return TraversalUtil.getTraverser(URLUtil.create(baseUrl + "/"), null, null);
    }

    public static Traverser getTraverser(String rootDir) {
        AssertionUtil.assertArgumentNotEmpty("rootDir", rootDir);
        URL url = ResourceUtil.getResource((String)(rootDir.endsWith("/") ? rootDir : rootDir + "/"));
        return TraversalUtil.getTraverser(url, null, rootDir);
    }

    public static Traverser[] getTraversers(String rootPackage) {
        if (StringUtil.isEmpty(rootPackage)) {
            return EMPTY_ARRAY;
        }
        String baseName = TraversalUtil.toDirectoryName(rootPackage);
        ArrayList<Traverser> list = CollectionsUtil.newArrayList();
        Iterator<URL> it = ClassLoaderUtil.getResources(baseName);
        while (it.hasNext()) {
            URL url = it.next();
            Traverser resourcesType = TraversalUtil.getTraverser(url, rootPackage, baseName);
            if (resourcesType == null) continue;
            list.add(resourcesType);
        }
        if (list.isEmpty()) {
            logger.log("WCL0014", rootPackage);
            return EMPTY_ARRAY;
        }
        return list.toArray(new Traverser[list.size()]);
    }

    protected static Traverser getTraverser(URL url, String rootPackage, String rootDir) {
        TraverserFactory factory = (TraverserFactory)traverserFactories.get(URLUtil.toCanonicalProtocol(url.getProtocol()));
        if (factory != null) {
            return factory.create(url, rootPackage, rootDir);
        }
        logger.log("WCL0013", ArrayUtil.asArray(rootPackage, url));
        return null;
    }

    protected static String toDirectoryName(String packageName) {
        if (StringUtil.isEmpty(packageName)) {
            return null;
        }
        return packageName.replace('.', '/') + "/";
    }

    protected static String toClassFile(String className) {
        AssertionUtil.assertArgumentNotNull("className", className);
        return className.replace('.', '/') + ".class";
    }

    protected static File getBaseDir(URL url, String baseName) {
        String[] paths;
        AssertionUtil.assertArgumentNotNull("url", url);
        File file = URLUtil.toFile(url);
        for (String path : paths = StringUtil.split(baseName, "/")) {
            file = file.getParentFile();
        }
        return file;
    }

    static {
        TraversalUtil.addTraverserFactory("file", (url, rootPackage, rootDir) -> new FileSystemTraverser(TraversalUtil.getBaseDir(url, rootDir), rootPackage, rootDir));
        TraversalUtil.addTraverserFactory("jar", (url, rootPackage, rootDir) -> new JarFileTraverser(url, rootPackage, rootDir));
        TraversalUtil.addTraverserFactory("zip", (url, rootPackage, rootDir) -> new JarFileTraverser(JarFileUtil.create(new File(ZipFileUtil.toZipFilePath(url))), rootPackage, rootDir));
        TraversalUtil.addTraverserFactory("code-source", (url, rootPackage, rootDir) -> new JarFileTraverser(URLUtil.create("jar:file:" + url.getPath()), rootPackage, rootDir));
        TraversalUtil.addTraverserFactory("vfszip", (url, rootPackage, rootDir) -> new VfsZipTraverser(url, rootPackage, rootDir));
    }

    public static class VfsZipTraverser
    implements Traverser {
        protected static final String WAR_CLASSES_PREFIX = "/WEB-INF/CLASSES/";
        protected final String rootPackage;
        protected final String rootDir;
        protected final URL zipUrl;
        protected final String prefix;
        protected final Set<String> entryNames = CollectionsUtil.newHashSet();

        public VfsZipTraverser(URL url, String rootPackage, String rootDir) {
            String zipUrlString;
            URL zipUrl = url;
            String prefix = "";
            if (rootPackage != null) {
                String[] paths;
                for (String path : paths = rootPackage.split("\\.")) {
                    zipUrl = URLUtil.create(zipUrl, "..");
                }
            }
            this.loadFromZip(zipUrl);
            if (this.entryNames.isEmpty() && (zipUrlString = zipUrl.toExternalForm()).toUpperCase().endsWith(WAR_CLASSES_PREFIX)) {
                URL warUrl = URLUtil.create(zipUrl, "../..");
                String path = warUrl.getPath();
                zipUrl = FileUtil.toURL(new File(path.substring(0, path.length() - 1)));
                prefix = zipUrlString.substring(warUrl.toExternalForm().length());
                this.loadFromZip(zipUrl);
            }
            this.rootPackage = rootPackage;
            this.rootDir = rootDir;
            this.zipUrl = zipUrl;
            this.prefix = prefix;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadFromZip(URL zipUrl) {
            ZipInputStream zis = new ZipInputStream(URLUtil.openStream(zipUrl));
            try {
                ZipEntry entry = null;
                while ((entry = ZipInputStreamUtil.getNextEntry(zis)) != null) {
                    this.entryNames.add(entry.getName());
                    ZipInputStreamUtil.closeEntry(zis);
                }
            }
            finally {
                CloseableUtil.close(zis);
            }
        }

        @Override
        public boolean isExistClass(String className) {
            String entryName = this.prefix + TraversalUtil.toClassFile(ClassUtil.concatName(this.rootPackage, className));
            return this.entryNames.contains(entryName);
        }

        @Override
        public void forEach(ClassHandler handler) {
            ZipInputStream zis = new ZipInputStream(URLUtil.openStream(this.zipUrl));
            try {
                ClassTraversalUtil.forEach(zis, this.prefix, (packageName, shortClassName) -> {
                    if (this.rootPackage == null || packageName != null && packageName.startsWith(this.rootPackage)) {
                        handler.processClass(packageName, shortClassName);
                    }
                });
            }
            finally {
                CloseableUtil.close(zis);
            }
        }

        @Override
        public void forEach(ResourceHandler handler) {
            ZipInputStream zis = new ZipInputStream(URLUtil.openStream(this.zipUrl));
            try {
                ResourceTraversalUtil.forEach(zis, this.prefix, (path, is) -> {
                    if (this.rootDir == null || path.startsWith(this.rootDir)) {
                        handler.processResource(path, is);
                    }
                });
            }
            finally {
                CloseableUtil.close(zis);
            }
        }

        @Override
        public void close() {
        }
    }

    public static class JarFileTraverser
    implements Traverser {
        protected final JarFile jarFile;
        protected final String rootPackage;
        protected final String rootDir;

        public JarFileTraverser(JarFile jarFile, String rootPackage, String rootDir) {
            this.jarFile = jarFile;
            this.rootPackage = rootPackage;
            this.rootDir = rootDir;
        }

        public JarFileTraverser(URL url, String rootPackage, String rootDir) {
            this(JarFileUtil.toJarFile(url), rootPackage, rootDir);
        }

        @Override
        public boolean isExistClass(String className) {
            return this.jarFile.getEntry(TraversalUtil.toClassFile(ClassUtil.concatName(this.rootPackage, className))) != null;
        }

        @Override
        public void forEach(ClassHandler handler) {
            ClassTraversalUtil.forEach(this.jarFile, (packageName, shortClassName) -> {
                if (this.rootPackage == null || packageName != null && packageName.startsWith(this.rootPackage)) {
                    handler.processClass(packageName, shortClassName);
                }
            });
        }

        @Override
        public void forEach(ResourceHandler handler) {
            ResourceTraversalUtil.forEach(this.jarFile, (path, is) -> {
                if (this.rootDir == null || path.startsWith(this.rootDir)) {
                    handler.processResource(path, is);
                }
            });
        }

        @Override
        public void close() {
            JarFileUtil.close(this.jarFile);
        }
    }

    public static class FileSystemTraverser
    implements Traverser {
        protected final File baseDir;
        protected final String rootPackage;
        protected final String rootDir;

        public FileSystemTraverser(File baseDir, String rootPackage, String rootDir) {
            this.baseDir = baseDir;
            this.rootPackage = rootPackage;
            this.rootDir = rootDir;
        }

        public FileSystemTraverser(URL url, String rootPackage, String rootDir) {
            this(URLUtil.toFile(url), rootPackage, rootDir);
        }

        @Override
        public boolean isExistClass(String className) {
            File file = new File(this.baseDir, TraversalUtil.toClassFile(ClassUtil.concatName(this.rootPackage, className)));
            return file.exists();
        }

        @Override
        public void forEach(ClassHandler handler) {
            ClassTraversalUtil.forEach(this.baseDir, this.rootPackage, handler);
        }

        @Override
        public void forEach(ResourceHandler handler) {
            ResourceTraversalUtil.forEach(this.baseDir, this.rootDir, handler);
        }

        @Override
        public void close() {
        }
    }

    public static interface TraverserFactory {
        public Traverser create(URL var1, String var2, String var3);
    }
}

