/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.codelibs.core.exception.IORuntimeException;
import org.codelibs.core.exception.ResourceNotFoundRuntimeException;
import org.codelibs.core.io.CloseableUtil;
import org.codelibs.core.jar.JarFileUtil;
import org.codelibs.core.misc.AssertionUtil;
import org.codelibs.core.net.URLUtil;

public abstract class ResourceUtil {
    public static String getResourcePath(String path, String extension) {
        AssertionUtil.assertArgumentNotNull("path", path);
        if (extension == null) {
            return path;
        }
        String ext = "." + extension;
        if (path.endsWith(ext)) {
            return path;
        }
        return path.replace('.', '/') + ext;
    }

    public static String getResourcePath(Class<?> clazz) {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        return clazz.getName().replace('.', '/') + ".class";
    }

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static URL getResource(String path) {
        AssertionUtil.assertArgumentNotEmpty("path", path);
        return ResourceUtil.getResource(path, null);
    }

    public static URL getResource(String path, String extension) {
        AssertionUtil.assertArgumentNotEmpty("path", path);
        URL url = ResourceUtil.getResourceNoException(path, extension);
        if (url != null) {
            return url;
        }
        throw new ResourceNotFoundRuntimeException(ResourceUtil.getResourcePath(path, extension));
    }

    public static URL getResourceNoException(String path) {
        AssertionUtil.assertArgumentNotEmpty("path", path);
        return ResourceUtil.getResourceNoException(path, null);
    }

    public static URL getResourceNoException(String path, String extension) {
        AssertionUtil.assertArgumentNotEmpty("path", path);
        return ResourceUtil.getResourceNoException(path, extension, Thread.currentThread().getContextClassLoader());
    }

    public static URL getResourceNoException(String path, String extension, ClassLoader loader) {
        AssertionUtil.assertArgumentNotNull("loader", loader);
        if (path == null || loader == null) {
            return null;
        }
        String p = ResourceUtil.getResourcePath(path, extension);
        return loader.getResource(p);
    }

    public static InputStream getResourceAsStream(String path) {
        AssertionUtil.assertArgumentNotEmpty("path", path);
        return ResourceUtil.getResourceAsStream(path, null);
    }

    public static InputStream getResourceAsStream(String path, String extension) {
        AssertionUtil.assertArgumentNotEmpty("path", path);
        URL url = ResourceUtil.getResource(path, extension);
        return URLUtil.openStream(url);
    }

    public static InputStream getResourceAsStreamNoException(String path) {
        AssertionUtil.assertArgumentNotEmpty("path", path);
        return ResourceUtil.getResourceAsStreamNoException(path, null);
    }

    public static InputStream getResourceAsStreamNoException(String path, String extension) {
        AssertionUtil.assertArgumentNotEmpty("path", path);
        URL url = ResourceUtil.getResourceNoException(path, extension);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean isExist(String path) {
        AssertionUtil.assertArgumentNotEmpty("path", path);
        return ResourceUtil.getResourceNoException(path) != null;
    }

    public static Properties getProperties(String path) {
        AssertionUtil.assertArgumentNotEmpty("path", path);
        Properties props = new Properties();
        InputStream is = ResourceUtil.getResourceAsStream(path);
        try {
            props.load(is);
            Properties properties = props;
            return properties;
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    public static String getExtension(String path) {
        AssertionUtil.assertArgumentNotNull("path", path);
        int extPos = path.lastIndexOf(".");
        if (extPos >= 0) {
            return path.substring(extPos + 1);
        }
        return null;
    }

    public static String removeExtension(String path) {
        AssertionUtil.assertArgumentNotNull("path", path);
        int extPos = path.lastIndexOf(".");
        if (extPos >= 0) {
            return path.substring(0, extPos);
        }
        return path;
    }

    public static File getBuildDir(Class<?> clazz) {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        return ResourceUtil.getBuildDir(ResourceUtil.getResourcePath(clazz));
    }

    public static File getBuildDir(String path) {
        AssertionUtil.assertArgumentNotEmpty("path", path);
        File dir = null;
        URL url = ResourceUtil.getResource(path);
        if ("file".equals(url.getProtocol())) {
            int num = path.split("/").length;
            dir = new File(ResourceUtil.getFileName(url));
            for (int i = 0; i < num; ++i) {
                dir = dir.getParentFile();
            }
        } else {
            dir = new File(JarFileUtil.toJarFilePath(url));
        }
        return dir;
    }

    public static String toExternalForm(URL url) {
        AssertionUtil.assertArgumentNotNull("url", url);
        String s = url.toExternalForm();
        return URLUtil.decode(s, "UTF8");
    }

    public static String getFileName(URL url) {
        AssertionUtil.assertArgumentNotNull("url", url);
        String s = url.getFile();
        return URLUtil.decode(s, "UTF8");
    }

    public static File getFile(URL url) {
        AssertionUtil.assertArgumentNotNull("url", url);
        File file = new File(ResourceUtil.getFileName(url));
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }

    public static File getResourceAsFile(String path) {
        AssertionUtil.assertArgumentNotEmpty("path", path);
        return ResourceUtil.getResourceAsFile(path, null);
    }

    public static File getResourceAsFile(String path, String extension) {
        AssertionUtil.assertArgumentNotEmpty("path", path);
        return ResourceUtil.getFile(ResourceUtil.getResource(path, extension));
    }

    public static File getResourceAsFileNoException(Class<?> clazz) {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        return ResourceUtil.getResourceAsFileNoException(ResourceUtil.getResourcePath(clazz));
    }

    public static File getResourceAsFileNoException(String path) {
        AssertionUtil.assertArgumentNotEmpty("path", path);
        URL url = ResourceUtil.getResourceNoException(path);
        if (url == null) {
            return null;
        }
        return ResourceUtil.getFile(url);
    }

    public static String convertPath(String path, Class<?> clazz) {
        AssertionUtil.assertArgumentNotEmpty("path", path);
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        if (ResourceUtil.isExist(path)) {
            return path;
        }
        String prefix = clazz.getName().replace('.', '/').replaceFirst("/[^/]+$", "");
        String extendedPath = prefix + "/" + path;
        if (ResourceUtil.getResourceNoException(extendedPath) != null) {
            return extendedPath;
        }
        return path;
    }
}

