/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Properties;
import org.codelibs.core.exception.IORuntimeException;
import org.codelibs.core.io.CloseableUtil;
import org.codelibs.core.io.ReaderUtil;
import org.codelibs.core.io.ResourceUtil;
import org.codelibs.core.io.WriterUtil;
import org.codelibs.core.misc.AssertionUtil;
import org.codelibs.core.net.URLUtil;

public abstract class PropertiesUtil {
    public static void load(Properties props, InputStream in) {
        AssertionUtil.assertArgumentNotNull("props", props);
        AssertionUtil.assertArgumentNotNull("in", in);
        try {
            props.load(in);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void load(Properties props, Reader reader) {
        AssertionUtil.assertArgumentNotNull("props", props);
        AssertionUtil.assertArgumentNotNull("reader", reader);
        try {
            props.load(reader);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void load(Properties props, File file, String encoding) {
        AssertionUtil.assertArgumentNotNull("props", props);
        AssertionUtil.assertArgumentNotNull("file", file);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        Reader reader = ReaderUtil.create(file, encoding);
        try {
            props.load(reader);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            CloseableUtil.close(reader);
        }
    }

    public static void load(Properties props, File file) {
        PropertiesUtil.load(props, file, Charset.defaultCharset().name());
    }

    public static void load(Properties props, URL url) {
        AssertionUtil.assertArgumentNotNull("props", props);
        AssertionUtil.assertArgumentNotNull("url", url);
        InputStream in = URLUtil.openStream(url);
        try {
            props.load(in);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            CloseableUtil.close(in);
        }
    }

    public static void load(Properties props, String path) {
        AssertionUtil.assertArgumentNotNull("props", props);
        AssertionUtil.assertArgumentNotEmpty("path", path);
        PropertiesUtil.load(props, ResourceUtil.getResource(path));
    }

    public static void store(Properties props, OutputStream out, String comments) {
        AssertionUtil.assertArgumentNotNull("props", props);
        AssertionUtil.assertArgumentNotNull("out", out);
        try {
            props.store(out, comments);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void store(Properties props, Writer writer, String comments) {
        AssertionUtil.assertArgumentNotNull("props", props);
        AssertionUtil.assertArgumentNotNull("writer", writer);
        try {
            props.store(writer, comments);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void store(Properties props, File file, String encoding, String comments) {
        AssertionUtil.assertArgumentNotNull("props", props);
        AssertionUtil.assertArgumentNotNull("file", file);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        Writer writer = WriterUtil.create(file, encoding);
        try {
            props.store(writer, comments);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            CloseableUtil.close(writer);
        }
    }

    public static void store(Properties props, File file, String comments) {
        PropertiesUtil.store(props, file, Charset.defaultCharset().name(), comments);
    }
}

