/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.io;

import java.io.Closeable;
import java.io.IOException;
import org.codelibs.core.log.Logger;

public abstract class CloseableUtil {
    private static final Logger logger = Logger.getLogger(CloseableUtil.class);

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            logger.log(Logger.format("ECL0017", e.getMessage()), e);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

