/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.io;

import java.io.File;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.codelibs.core.collection.EnumerationIterator;
import org.codelibs.core.io.ClassHandler;
import org.codelibs.core.lang.ClassUtil;
import org.codelibs.core.misc.AssertionUtil;
import org.codelibs.core.zip.ZipInputStreamUtil;

public abstract class ClassTraversalUtil {
    protected static final String CLASS_SUFFIX = ".class";
    protected static final String WAR_FILE_EXTENSION = ".war";
    protected static final String WEB_INF_CLASSES_PATH = "WEB-INF/classes/";

    public static void forEach(File rootDir, ClassHandler handler) {
        AssertionUtil.assertArgumentNotNull("rootDir", rootDir);
        AssertionUtil.assertArgumentNotNull("handler", handler);
        ClassTraversalUtil.forEach(rootDir, null, handler);
    }

    public static void forEach(File rootDir, String rootPackage, ClassHandler handler) {
        AssertionUtil.assertArgumentNotNull("rootDir", rootDir);
        AssertionUtil.assertArgumentNotNull("handler", handler);
        File packageDir = ClassTraversalUtil.getPackageDir(rootDir, rootPackage);
        if (packageDir.exists()) {
            ClassTraversalUtil.traverseFileSystem(packageDir, rootPackage, handler);
        }
    }

    public static void forEach(JarFile jarFile, ClassHandler handler) {
        AssertionUtil.assertArgumentNotNull("jarFile", jarFile);
        AssertionUtil.assertArgumentNotNull("handler", handler);
        if (jarFile.getName().toLowerCase().endsWith(WAR_FILE_EXTENSION)) {
            ClassTraversalUtil.forEach(jarFile, WEB_INF_CLASSES_PATH, handler);
        } else {
            ClassTraversalUtil.forEach(jarFile, "", handler);
        }
    }

    public static void forEach(JarFile jarFile, String prefix, ClassHandler handler) {
        AssertionUtil.assertArgumentNotNull("jarFile", jarFile);
        AssertionUtil.assertArgumentNotNull("prefix", prefix);
        AssertionUtil.assertArgumentNotNull("handler", handler);
        int startPos = prefix.length();
        for (JarEntry entry : EnumerationIterator.iterable(jarFile.entries())) {
            String entryName = entry.getName().replace('\\', '/');
            if (!entryName.startsWith(prefix) || !entryName.endsWith(CLASS_SUFFIX)) continue;
            String className = entryName.substring(startPos, entryName.length() - CLASS_SUFFIX.length()).replace('/', '.');
            int pos = className.lastIndexOf(46);
            String packageName = pos == -1 ? null : className.substring(0, pos);
            String shortClassName = pos == -1 ? className : className.substring(pos + 1);
            handler.processClass(packageName, shortClassName);
        }
    }

    public static void forEach(ZipInputStream zipInputStream, ClassHandler handler) {
        AssertionUtil.assertArgumentNotNull("zipInputStream", zipInputStream);
        AssertionUtil.assertArgumentNotNull("handler", handler);
        ClassTraversalUtil.forEach(zipInputStream, "", handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forEach(ZipInputStream zipInputStream, String prefix, ClassHandler handler) {
        AssertionUtil.assertArgumentNotNull("zipInputStream", zipInputStream);
        AssertionUtil.assertArgumentNotNull("prefix", prefix);
        AssertionUtil.assertArgumentNotNull("handler", handler);
        int startPos = prefix.length();
        ZipEntry entry = null;
        while ((entry = ZipInputStreamUtil.getNextEntry(zipInputStream)) != null) {
            try {
                String entryName = entry.getName().replace('\\', '/');
                if (!entryName.startsWith(prefix) || !entryName.endsWith(CLASS_SUFFIX)) continue;
                String className = entryName.substring(startPos, entryName.length() - CLASS_SUFFIX.length()).replace('/', '.');
                int pos = className.lastIndexOf(46);
                String packageName = pos == -1 ? null : className.substring(0, pos);
                String shortClassName = pos == -1 ? className : className.substring(pos + 1);
                handler.processClass(packageName, shortClassName);
            }
            finally {
                ZipInputStreamUtil.closeEntry(zipInputStream);
            }
        }
    }

    protected static void traverseFileSystem(File dir, String packageName, ClassHandler handler) {
        for (File file : dir.listFiles()) {
            String fileName = file.getName();
            if (file.isDirectory()) {
                ClassTraversalUtil.traverseFileSystem(file, ClassUtil.concatName(packageName, fileName), handler);
                continue;
            }
            if (!fileName.endsWith(CLASS_SUFFIX)) continue;
            String shortClassName = fileName.substring(0, fileName.length() - CLASS_SUFFIX.length());
            handler.processClass(packageName, shortClassName);
        }
    }

    protected static File getPackageDir(File rootDir, String rootPackage) {
        File packageDir = rootDir;
        if (rootPackage != null) {
            for (String name : rootPackage.split("\\.")) {
                packageDir = new File(packageDir, name);
            }
        }
        return packageDir;
    }
}

