/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.exception;

import java.sql.SQLException;
import org.codelibs.core.collection.ArrayUtil;
import org.codelibs.core.exception.ClRuntimeException;
import org.codelibs.core.exception.ClSQLException;
import org.codelibs.core.message.MessageFormatter;

public class SQLRuntimeException
extends ClRuntimeException {
    private static final long serialVersionUID = 2533513110369526191L;

    public SQLRuntimeException(SQLException cause) {
        super("ECL0072", ArrayUtil.asArray(SQLRuntimeException.getSql(cause), SQLRuntimeException.getRealMessage(cause), Integer.toString(cause.getErrorCode()), cause.getSQLState()), cause);
    }

    protected static String getSql(SQLException cause) {
        if (cause instanceof ClSQLException) {
            return ((ClSQLException)cause).getSql();
        }
        return "";
    }

    protected static String getRealMessage(SQLException cause) {
        StringBuilder buf = new StringBuilder(256);
        buf.append(cause.getMessage()).append(" : [");
        for (SQLException next = cause.getNextException(); next != null; next = next.getNextException()) {
            buf.append(MessageFormatter.getSimpleMessage("ECL0071", next.getMessage(), Integer.toString(next.getErrorCode()), next.getSQLState())).append("], [");
        }
        for (Throwable t = cause.getCause(); t != null; t = t.getCause()) {
            buf.append(t.getMessage()).append("], [");
        }
        buf.setLength(buf.length() - 4);
        return new String(buf);
    }
}

