/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.exception;

import org.codelibs.core.message.MessageFormatter;

public class ClRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -4452607868694297329L;
    private final String messageCode;
    private final Object[] args;
    private final String message;
    private final String simpleMessage;

    public ClRuntimeException(String messageCode) {
        this(messageCode, new Object[0], null);
    }

    public ClRuntimeException(String messageCode, Object[] args) {
        this(messageCode, args, null);
    }

    public ClRuntimeException(String messageCode, Throwable cause) {
        this(messageCode, new Object[0], cause);
    }

    public ClRuntimeException(String messageCode, Object[] args, Throwable cause) {
        super(cause);
        this.messageCode = messageCode;
        this.args = args;
        this.simpleMessage = MessageFormatter.getSimpleMessage(messageCode, args);
        this.message = "[" + messageCode + "]" + this.simpleMessage;
    }

    public String getMessageCode() {
        return this.messageCode;
    }

    public Object[] getArgs() {
        return this.args;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public final String getSimpleMessage() {
        return this.simpleMessage;
    }
}

