/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.convert;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.codelibs.core.collection.MultiIterator;
import org.codelibs.core.exception.ClUnsupportedOperationException;
import org.codelibs.core.exception.ParseRuntimeException;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.misc.AssertionUtil;
import org.codelibs.core.misc.LocaleUtil;

public abstract class TimestampConversionUtil {
    protected static final int[] STYLES = new int[]{3, 2, 1, 0};

    public static String getShortPattern() {
        return TimestampConversionUtil.getShortPattern(LocaleUtil.getDefault());
    }

    public static String getShortPattern(Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        return ((SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, locale)).toPattern();
    }

    public static String getMediumPattern() {
        return TimestampConversionUtil.getMediumPattern(LocaleUtil.getDefault());
    }

    public static String getMediumPattern(Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        return ((SimpleDateFormat)DateFormat.getDateTimeInstance(2, 2, locale)).toPattern();
    }

    public static String getLongPattern() {
        return TimestampConversionUtil.getLongPattern(LocaleUtil.getDefault());
    }

    public static String getLongPattern(Locale locale) {
        return ((SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1, locale)).toPattern();
    }

    public static String getFullPattern() {
        return TimestampConversionUtil.getFullPattern(LocaleUtil.getDefault());
    }

    public static String getFullPattern(Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        return ((SimpleDateFormat)DateFormat.getDateTimeInstance(0, 0, locale)).toPattern();
    }

    public static Date toDate(Object src) {
        return TimestampConversionUtil.toDate(src, null, LocaleUtil.getDefault());
    }

    public static Date toDate(Object src, String pattern) {
        return TimestampConversionUtil.toDate(src, pattern, LocaleUtil.getDefault());
    }

    public static Date toDate(Object src, Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        return TimestampConversionUtil.toDate(src, null, locale);
    }

    protected static Date toDate(Object src, String pattern, Locale locale) {
        SimpleDateFormat format;
        Date date;
        if (src == null) {
            return null;
        }
        if (src.getClass() == Date.class) {
            return (Date)src;
        }
        if (src instanceof Date) {
            return new Date(((Date)src).getTime());
        }
        if (src instanceof Calendar) {
            return new Date(((Calendar)src).getTimeInMillis());
        }
        String str = src.toString();
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        if (StringUtil.isNotEmpty(pattern) && (date = TimestampConversionUtil.toDate(str, format = new SimpleDateFormat(pattern, locale))) != null) {
            return date;
        }
        Date date2 = TimestampConversionUtil.toDate(str, locale);
        if (date2 != null) {
            return date2;
        }
        Timestamp timestamp = TimestampConversionUtil.toSqlTimestampJdbcEscape(str);
        if (timestamp != null) {
            return new Date(timestamp.getTime());
        }
        throw new ParseRuntimeException(str);
    }

    public static Calendar toCalendar(Object src) {
        return TimestampConversionUtil.toCalendar(src, null, LocaleUtil.getDefault());
    }

    public static Calendar toCalendar(Object src, String pattern) {
        return TimestampConversionUtil.toCalendar(src, pattern, LocaleUtil.getDefault());
    }

    public static Calendar toCalendar(Object src, Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        return TimestampConversionUtil.toCalendar(src, null, locale);
    }

    protected static Calendar toCalendar(Object src, String pattern, Locale locale) {
        SimpleDateFormat format;
        Date date;
        if (src == null) {
            return null;
        }
        if (src instanceof Calendar) {
            return (Calendar)src;
        }
        if (src instanceof Date) {
            return TimestampConversionUtil.toCalendar((Date)src, locale);
        }
        String str = src.toString();
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        if (StringUtil.isNotEmpty(pattern) && (date = TimestampConversionUtil.toDate(str, format = new SimpleDateFormat(pattern))) != null) {
            return TimestampConversionUtil.toCalendar(date, locale);
        }
        Date date2 = TimestampConversionUtil.toDate(str, locale);
        if (date2 != null) {
            return TimestampConversionUtil.toCalendar(date2, locale);
        }
        Timestamp timestamp = TimestampConversionUtil.toSqlTimestampJdbcEscape(str);
        if (timestamp != null) {
            return TimestampConversionUtil.toCalendar(timestamp, locale);
        }
        throw new ParseRuntimeException(str);
    }

    public static Timestamp toSqlTimestamp(Object src) {
        return TimestampConversionUtil.toSqlTimestamp(src, null, LocaleUtil.getDefault());
    }

    public static Timestamp toSqlTimestamp(Object src, String pattern) {
        return TimestampConversionUtil.toSqlTimestamp(src, pattern, LocaleUtil.getDefault());
    }

    public static Timestamp toSqlTimestamp(Object src, Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        return TimestampConversionUtil.toSqlTimestamp(src, null, locale);
    }

    protected static Timestamp toSqlTimestamp(Object src, String pattern, Locale locale) {
        SimpleDateFormat format;
        Date date;
        if (src == null) {
            return null;
        }
        if (src.getClass() == Timestamp.class) {
            return (Timestamp)src;
        }
        if (src instanceof Date) {
            return new Timestamp(((Date)src).getTime());
        }
        if (src instanceof Calendar) {
            return new Timestamp(((Calendar)src).getTimeInMillis());
        }
        String str = src.toString();
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        if (StringUtil.isNotEmpty(pattern) && (date = TimestampConversionUtil.toDate(str, format = new SimpleDateFormat(pattern, locale))) != null) {
            return new Timestamp(date.getTime());
        }
        Date date2 = TimestampConversionUtil.toDate(str, locale);
        if (date2 != null) {
            return new Timestamp(date2.getTime());
        }
        Timestamp timestamp = TimestampConversionUtil.toSqlTimestampJdbcEscape(str);
        if (timestamp != null) {
            return timestamp;
        }
        throw new ParseRuntimeException(str);
    }

    protected static Date toDate(String str, Locale locale) {
        for (DateFormat format : MultiIterator.iterable(new DateFormatIterator(locale), new PlainDateFormatIterator(str, locale))) {
            Date date;
            if (format == null || (date = TimestampConversionUtil.toDate(str, format)) == null) continue;
            return date;
        }
        return null;
    }

    protected static Date toDate(String str, DateFormat format) {
        ParsePosition pos = new ParsePosition(0);
        Date date = format.parse(str, pos);
        if (date == null) {
            return null;
        }
        int index = pos.getIndex();
        if (index == 0) {
            return null;
        }
        if (index < str.length()) {
            return null;
        }
        return date;
    }

    protected static Calendar toCalendar(Date date, Locale locale) {
        Calendar calendar = locale == null ? Calendar.getInstance() : Calendar.getInstance(locale);
        calendar.setTime(date);
        return calendar;
    }

    protected static Timestamp toSqlTimestampJdbcEscape(String str) {
        try {
            return Timestamp.valueOf(str);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    protected static String toPlainPattern(String pattern) {
        int pos;
        StringBuilder buf = new StringBuilder(pattern.length());
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (!Character.isLetterOrDigit(ch) && !Character.isWhitespace(ch)) continue;
            buf.append(ch);
        }
        if (buf.indexOf("yy") == -1 && (pos = buf.indexOf("y")) != -1) {
            buf.replace(pos, pos + 1, "yy");
        }
        if (buf.indexOf("MM") == -1 && (pos = buf.indexOf("M")) != -1) {
            buf.replace(pos, pos + 1, "MM");
        }
        if (buf.indexOf("dd") == -1 && (pos = buf.indexOf("d")) != -1) {
            buf.replace(pos, pos + 1, "dd");
        }
        if (buf.indexOf("HH") == -1 && (pos = buf.indexOf("H")) != -1) {
            buf.replace(pos, pos + 1, "HH");
        }
        if (buf.indexOf("mm") == -1 && (pos = buf.indexOf("m")) != -1) {
            buf.replace(pos, pos + 1, "mm");
        }
        if (buf.indexOf("ss") == -1 && (pos = buf.indexOf("s")) != -1) {
            buf.replace(pos, pos + 1, "ss");
        }
        return new String(buf);
    }

    protected static class PlainDateFormatIterator
    implements Iterator<DateFormat> {
        protected final String src;
        protected final Locale locale;
        protected int index;

        public PlainDateFormatIterator(String src, Locale locale) {
            this.src = src;
            this.locale = locale;
        }

        @Override
        public boolean hasNext() {
            return this.index < STYLES.length;
        }

        @Override
        public DateFormat next() {
            SimpleDateFormat simpleFormat;
            String pattern;
            int style;
            DateFormat format;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if ((format = DateFormat.getDateTimeInstance(style = STYLES[this.index++], style, this.locale)) instanceof SimpleDateFormat && (pattern = TimestampConversionUtil.toPlainPattern((simpleFormat = (SimpleDateFormat)format).toPattern())).length() == this.src.length()) {
                return new SimpleDateFormat(pattern);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new ClUnsupportedOperationException("remove");
        }
    }

    protected static class DateFormatIterator
    implements Iterator<DateFormat> {
        protected final Locale locale;
        protected int index;

        public DateFormatIterator(Locale locale) {
            this.locale = locale;
        }

        @Override
        public boolean hasNext() {
            return this.index < STYLES.length;
        }

        @Override
        public DateFormat next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int style = STYLES[this.index++];
            return DateFormat.getDateTimeInstance(style, style, this.locale);
        }

        @Override
        public void remove() {
            throw new ClUnsupportedOperationException("remove");
        }
    }
}

