/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.convert;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.codelibs.core.collection.MultiIterator;
import org.codelibs.core.exception.ClUnsupportedOperationException;
import org.codelibs.core.exception.ParseRuntimeException;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.misc.AssertionUtil;
import org.codelibs.core.misc.LocaleUtil;

public abstract class DateConversionUtil {
    protected static final int[] STYLES = new int[]{3, 2, 1, 0};

    public static String getShortPattern() {
        return DateConversionUtil.getShortPattern(LocaleUtil.getDefault());
    }

    public static String getShortPattern(Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        return ((SimpleDateFormat)DateFormat.getDateInstance(3, locale)).toPattern();
    }

    public static String getMediumPattern() {
        return DateConversionUtil.getMediumPattern(LocaleUtil.getDefault());
    }

    public static String getMediumPattern(Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        return ((SimpleDateFormat)DateFormat.getDateInstance(2, locale)).toPattern();
    }

    public static String getLongPattern() {
        return DateConversionUtil.getLongPattern(LocaleUtil.getDefault());
    }

    public static String getLongPattern(Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        return ((SimpleDateFormat)DateFormat.getDateInstance(1, locale)).toPattern();
    }

    public static String getFullPattern() {
        return DateConversionUtil.getFullPattern(LocaleUtil.getDefault());
    }

    public static String getFullPattern(Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        return ((SimpleDateFormat)DateFormat.getDateInstance(0, locale)).toPattern();
    }

    public static Date toDate(Object src) {
        return DateConversionUtil.toDate(src, null, LocaleUtil.getDefault());
    }

    public static Date toDate(Object src, String pattern) {
        return DateConversionUtil.toDate(src, pattern, LocaleUtil.getDefault());
    }

    public static Date toDate(Object src, Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        return DateConversionUtil.toDate(src, null, locale);
    }

    protected static Date toDate(Object src, String pattern, Locale locale) {
        SimpleDateFormat format;
        Date date;
        if (src == null) {
            return null;
        }
        if (src.getClass() == Date.class) {
            return (Date)src;
        }
        if (src instanceof Date) {
            return new Date(((Date)src).getTime());
        }
        if (src instanceof Calendar) {
            return new Date(((Calendar)src).getTimeInMillis());
        }
        String str = src.toString();
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        if (StringUtil.isNotEmpty(pattern) && (date = DateConversionUtil.toDate(str, format = new SimpleDateFormat(pattern, locale))) != null) {
            return date;
        }
        Date date2 = DateConversionUtil.toDate(str, locale);
        if (date2 != null) {
            return date2;
        }
        java.sql.Date sqlDate = DateConversionUtil.toSqlDateJdbcEscape(str);
        if (sqlDate != null) {
            return new java.sql.Date(sqlDate.getTime());
        }
        throw new ParseRuntimeException(str);
    }

    public static Calendar toCalendar(Object src) {
        return DateConversionUtil.toCalendar(src, null, LocaleUtil.getDefault());
    }

    public static Calendar toCalendar(Object src, String pattern) {
        return DateConversionUtil.toCalendar(src, pattern, LocaleUtil.getDefault());
    }

    public static Calendar toCalendar(Object src, Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        return DateConversionUtil.toCalendar(src, null, locale);
    }

    protected static Calendar toCalendar(Object src, String pattern, Locale locale) {
        SimpleDateFormat format;
        Date date;
        if (src == null) {
            return null;
        }
        if (src instanceof Calendar) {
            return (Calendar)src;
        }
        if (src instanceof Date) {
            return DateConversionUtil.toCalendar((Date)src, locale);
        }
        String str = src.toString();
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        if (StringUtil.isNotEmpty(pattern) && (date = DateConversionUtil.toDate(str, format = new SimpleDateFormat(pattern, locale))) != null) {
            return DateConversionUtil.toCalendar(date, locale);
        }
        Date date2 = DateConversionUtil.toDate(str, locale);
        if (date2 != null) {
            return DateConversionUtil.toCalendar(date2, locale);
        }
        java.sql.Date sqlDate = DateConversionUtil.toSqlDateJdbcEscape(str);
        if (sqlDate != null) {
            return DateConversionUtil.toCalendar(sqlDate, locale);
        }
        throw new ParseRuntimeException(str);
    }

    public static java.sql.Date toSqlDate(Object src) {
        return DateConversionUtil.toSqlDate(src, null, LocaleUtil.getDefault());
    }

    public static java.sql.Date toSqlDate(Object src, String pattern) {
        return DateConversionUtil.toSqlDate(src, pattern, LocaleUtil.getDefault());
    }

    public static java.sql.Date toSqlDate(Object src, Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        return DateConversionUtil.toSqlDate(src, null, locale);
    }

    protected static java.sql.Date toSqlDate(Object src, String pattern, Locale locale) {
        SimpleDateFormat format;
        Date date;
        if (src == null) {
            return null;
        }
        if (src instanceof java.sql.Date) {
            return (java.sql.Date)src;
        }
        if (src instanceof Date) {
            return new java.sql.Date(((Date)src).getTime());
        }
        if (src instanceof Calendar) {
            return new java.sql.Date(((Calendar)src).getTimeInMillis());
        }
        String str = src.toString();
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        if (StringUtil.isNotEmpty(pattern) && (date = DateConversionUtil.toDate(str, format = new SimpleDateFormat(pattern, locale))) != null) {
            return new java.sql.Date(date.getTime());
        }
        Date date2 = DateConversionUtil.toDate(str, locale);
        if (date2 != null) {
            return new java.sql.Date(date2.getTime());
        }
        java.sql.Date sqlDate = DateConversionUtil.toSqlDateJdbcEscape(str);
        if (sqlDate != null) {
            return sqlDate;
        }
        throw new ParseRuntimeException(str);
    }

    protected static Date toDate(String str, Locale locale) {
        for (DateFormat format : MultiIterator.iterable(new DateFormatIterator(locale), new PlainDateFormatIterator(str, locale))) {
            Date date;
            if (format == null || (date = DateConversionUtil.toDate(str, format)) == null) continue;
            return date;
        }
        return null;
    }

    protected static Date toDate(String str, DateFormat format) {
        ParsePosition pos = new ParsePosition(0);
        Date date = format.parse(str, pos);
        if (date == null) {
            return null;
        }
        int index = pos.getIndex();
        if (index == 0) {
            return null;
        }
        if (index < str.length()) {
            return null;
        }
        return date;
    }

    protected static Calendar toCalendar(Date date, Locale locale) {
        Calendar calendar = locale == null ? Calendar.getInstance() : Calendar.getInstance(locale);
        calendar.setTime(date);
        return calendar;
    }

    protected static java.sql.Date toSqlDateJdbcEscape(String str) {
        try {
            return java.sql.Date.valueOf(str);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    protected static String toPlainPattern(String pattern) {
        int pos;
        StringBuilder buf = new StringBuilder(pattern.length());
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (!Character.isLetterOrDigit(ch) && !Character.isWhitespace(ch)) continue;
            buf.append(ch);
        }
        if (buf.indexOf("yy") == -1 && (pos = buf.indexOf("y")) != -1) {
            buf.replace(pos, pos + 1, "yy");
        }
        if (buf.indexOf("MM") == -1 && (pos = buf.indexOf("M")) != -1) {
            buf.replace(pos, pos + 1, "MM");
        }
        if (buf.indexOf("dd") == -1 && (pos = buf.indexOf("d")) != -1) {
            buf.replace(pos, pos + 1, "dd");
        }
        return new String(buf);
    }

    protected static class PlainDateFormatIterator
    implements Iterator<DateFormat> {
        protected final String src;
        protected final Locale locale;
        protected int index;

        public PlainDateFormatIterator(String src, Locale locale) {
            this.src = src;
            this.locale = locale;
        }

        @Override
        public boolean hasNext() {
            return this.index < STYLES.length;
        }

        @Override
        public DateFormat next() {
            SimpleDateFormat simpleFormat;
            String pattern;
            int style;
            DateFormat format;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if ((format = DateFormat.getDateInstance(style = STYLES[this.index++], this.locale)) instanceof SimpleDateFormat && (pattern = DateConversionUtil.toPlainPattern((simpleFormat = (SimpleDateFormat)format).toPattern())).length() == this.src.length()) {
                return new SimpleDateFormat(pattern);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new ClUnsupportedOperationException("remove");
        }
    }

    protected static class DateFormatIterator
    implements Iterator<DateFormat> {
        protected final Locale locale;
        protected int index;

        public DateFormatIterator(Locale locale) {
            this.locale = locale;
        }

        @Override
        public boolean hasNext() {
            return this.index < STYLES.length;
        }

        @Override
        public DateFormat next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int style = STYLES[this.index++];
            return DateFormat.getDateInstance(style, this.locale);
        }

        @Override
        public void remove() {
            throw new ClUnsupportedOperationException("remove");
        }
    }
}

