/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.concurrent;

import java.util.concurrent.ForkJoinPool;
import org.codelibs.core.log.Logger;

public class CommonPoolUtil {
    private static final Logger logger = Logger.getLogger(CommonPoolUtil.class);

    private CommonPoolUtil() {
    }

    public static void execute(Runnable task) {
        ForkJoinPool.commonPool().execute(() -> {
            Thread currentThread = Thread.currentThread();
            ClassLoader orignal = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(CommonPoolUtil.class.getClassLoader());
            try {
                task.run();
            }
            catch (Exception e) {
                logger.error("Uncaught exception from " + task, e);
            }
            finally {
                currentThread.setContextClassLoader(orignal);
            }
        });
    }
}

