/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.collection;

import java.util.Iterator;
import org.codelibs.core.collection.Indexed;
import org.codelibs.core.exception.ClUnsupportedOperationException;
import org.codelibs.core.misc.AssertionUtil;

public class IndexedIterator<T>
implements Iterator<Indexed<T>> {
    protected final Iterator<T> iterator;
    protected int index;

    public static <T> Iterable<Indexed<T>> indexed(Iterable<T> iterable) {
        AssertionUtil.assertArgumentNotNull("iterable", iterable);
        return IndexedIterator.indexed(iterable.iterator());
    }

    public static <T> Iterable<Indexed<T>> indexed(Iterator<T> iterator) {
        AssertionUtil.assertArgumentNotNull("iterator", iterator);
        return () -> new IndexedIterator(iterator);
    }

    public IndexedIterator(Iterator<T> iterator) {
        AssertionUtil.assertArgumentNotNull("iterator", iterator);
        this.iterator = iterator;
        this.index = 0;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Indexed<T> next() {
        return new Indexed<T>(this.iterator.next(), this.index++);
    }

    @Override
    public void remove() {
        throw new ClUnsupportedOperationException("remove");
    }
}

