/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.collection;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codelibs.core.collection.CollectionsUtil;
import org.codelibs.core.message.MessageFormatter;
import org.codelibs.core.misc.AssertionUtil;

public abstract class ArrayUtil {
    public static boolean[] asBooleanArray(boolean ... elements) {
        return elements;
    }

    public static char[] asCharArray(char ... elements) {
        return elements;
    }

    public static byte[] asByteArray(byte ... elements) {
        return elements;
    }

    public static short[] asShortArray(short ... elements) {
        return elements;
    }

    public static int[] asIntArray(int ... elements) {
        return elements;
    }

    public static long[] asLongArray(long ... elements) {
        return elements;
    }

    public static float[] asFloatArray(float ... elements) {
        return elements;
    }

    public static double[] asDoubleArray(double ... elements) {
        return elements;
    }

    public static Object[] asArray(Object ... elements) {
        return elements;
    }

    public static String[] asStringArray(String ... elements) {
        return elements;
    }

    public static Boolean[] asArray(Boolean ... elements) {
        return elements;
    }

    public static Character[] asArray(Character ... elements) {
        return elements;
    }

    public static Byte[] asArray(Byte ... elements) {
        return elements;
    }

    public static Short[] asArray(Short ... elements) {
        return elements;
    }

    public static Integer[] asArray(Integer ... elements) {
        return elements;
    }

    public static Long[] asArray(Long ... elements) {
        return elements;
    }

    public static Float[] asArray(Float ... elements) {
        return elements;
    }

    public static Double[] asArray(Double ... elements) {
        return elements;
    }

    public static BigInteger[] asArray(BigInteger ... elements) {
        return elements;
    }

    public static BigDecimal[] asArray(BigDecimal ... elements) {
        return elements;
    }

    public static <T> T[] add(T[] array, T obj) {
        AssertionUtil.assertArgumentNotNull("array", array);
        int length = array.length;
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), length + 1);
        System.arraycopy(array, 0, newArray, 0, length);
        newArray[length] = obj;
        return newArray;
    }

    public static boolean[] add(boolean[] array, boolean value) {
        AssertionUtil.assertArgumentNotNull("array", array);
        boolean[] newArray = (boolean[])Array.newInstance(Boolean.TYPE, array.length + 1);
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = value;
        return newArray;
    }

    public static byte[] add(byte[] array, byte value) {
        AssertionUtil.assertArgumentNotNull("array", array);
        byte[] newArray = (byte[])Array.newInstance(Byte.TYPE, array.length + 1);
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = value;
        return newArray;
    }

    public static short[] add(short[] array, short value) {
        AssertionUtil.assertArgumentNotNull("array", array);
        short[] newArray = (short[])Array.newInstance(Short.TYPE, array.length + 1);
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = value;
        return newArray;
    }

    public static int[] add(int[] array, int value) {
        AssertionUtil.assertArgumentNotNull("array", array);
        int[] newArray = (int[])Array.newInstance(Integer.TYPE, array.length + 1);
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = value;
        return newArray;
    }

    public static long[] add(long[] array, long value) {
        AssertionUtil.assertArgumentNotNull("array", array);
        long[] newArray = (long[])Array.newInstance(Long.TYPE, array.length + 1);
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = value;
        return newArray;
    }

    public static float[] add(float[] array, float value) {
        AssertionUtil.assertArgumentNotNull("array", array);
        float[] newArray = (float[])Array.newInstance(Float.TYPE, array.length + 1);
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = value;
        return newArray;
    }

    public static double[] add(double[] array, double value) {
        AssertionUtil.assertArgumentNotNull("array", array);
        double[] newArray = (double[])Array.newInstance(Double.TYPE, array.length + 1);
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = value;
        return newArray;
    }

    public static <T> T[] addAll(T[] a, T[] b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.length == 0) {
            return b;
        }
        if (b.length == 0) {
            return a;
        }
        Object[] array = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length + b.length);
        System.arraycopy(a, 0, array, 0, a.length);
        System.arraycopy(b, 0, array, a.length, b.length);
        return array;
    }

    public static boolean[] addAll(boolean[] a, boolean[] b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.length == 0) {
            return b;
        }
        if (b.length == 0) {
            return a;
        }
        boolean[] array = (boolean[])Array.newInstance(Boolean.TYPE, a.length + b.length);
        System.arraycopy(a, 0, array, 0, a.length);
        System.arraycopy(b, 0, array, a.length, b.length);
        return array;
    }

    public static byte[] addAll(byte[] a, byte[] b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.length == 0) {
            return b;
        }
        if (b.length == 0) {
            return a;
        }
        byte[] array = (byte[])Array.newInstance(Byte.TYPE, a.length + b.length);
        System.arraycopy(a, 0, array, 0, a.length);
        System.arraycopy(b, 0, array, a.length, b.length);
        return array;
    }

    public static short[] addAll(short[] a, short[] b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.length == 0) {
            return b;
        }
        if (b.length == 0) {
            return a;
        }
        short[] array = (short[])Array.newInstance(Short.TYPE, a.length + b.length);
        System.arraycopy(a, 0, array, 0, a.length);
        System.arraycopy(b, 0, array, a.length, b.length);
        return array;
    }

    public static int[] addAll(int[] a, int[] b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.length == 0) {
            return b;
        }
        if (b.length == 0) {
            return a;
        }
        int[] array = (int[])Array.newInstance(Integer.TYPE, a.length + b.length);
        System.arraycopy(a, 0, array, 0, a.length);
        System.arraycopy(b, 0, array, a.length, b.length);
        return array;
    }

    public static long[] addAll(long[] a, long[] b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.length == 0) {
            return b;
        }
        if (b.length == 0) {
            return a;
        }
        long[] array = (long[])Array.newInstance(Long.TYPE, a.length + b.length);
        System.arraycopy(a, 0, array, 0, a.length);
        System.arraycopy(b, 0, array, a.length, b.length);
        return array;
    }

    public static float[] addAll(float[] a, float[] b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.length == 0) {
            return b;
        }
        if (b.length == 0) {
            return a;
        }
        float[] array = (float[])Array.newInstance(Float.TYPE, a.length + b.length);
        System.arraycopy(a, 0, array, 0, a.length);
        System.arraycopy(b, 0, array, a.length, b.length);
        return array;
    }

    public static double[] addAll(double[] a, double[] b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.length == 0) {
            return b;
        }
        if (b.length == 0) {
            return a;
        }
        double[] array = (double[])Array.newInstance(Double.TYPE, a.length + b.length);
        System.arraycopy(a, 0, array, 0, a.length);
        System.arraycopy(b, 0, array, a.length, b.length);
        return array;
    }

    public static char[] addAll(char[] a, char[] b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.length == 0) {
            return b;
        }
        if (b.length == 0) {
            return a;
        }
        char[] array = (char[])Array.newInstance(Character.TYPE, a.length + b.length);
        System.arraycopy(a, 0, array, 0, a.length);
        System.arraycopy(b, 0, array, a.length, b.length);
        return array;
    }

    public static <T> int indexOf(T[] array, T obj) {
        return ArrayUtil.indexOf(array, obj, 0);
    }

    public static <T> int indexOf(T[] array, T obj, int fromIndex) {
        if (array != null) {
            for (int i = fromIndex; i < array.length; ++i) {
                T o = array[i];
                if (!(o != null ? o.equals(obj) : obj == null)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(boolean[] array, boolean value) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != value) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(byte[] array, byte value) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != value) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(short[] array, short value) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != value) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(int[] array, int value) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != value) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(long[] array, long value) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != value) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(float[] array, float value) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != value) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(double[] array, double value) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != value) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(char[] array, char value) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != value) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> T[] remove(T[] array, T obj) {
        int index = ArrayUtil.indexOf(array, obj);
        if (index < 0) {
            return array;
        }
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
        if (index > 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        if (index < array.length - 1) {
            System.arraycopy(array, index + 1, newArray, index, newArray.length - index);
        }
        return newArray;
    }

    public static <T> boolean isEmpty(T[] arrays) {
        return arrays == null || arrays.length == 0;
    }

    public static <T> boolean isNotEmpty(T[] arrays) {
        return arrays != null && arrays.length != 0;
    }

    public static boolean isEmpty(boolean[] arrays) {
        return arrays == null || arrays.length == 0;
    }

    public static boolean isNotEmpty(boolean[] arrays) {
        return arrays != null && arrays.length != 0;
    }

    public static boolean isEmpty(byte[] arrays) {
        return arrays == null || arrays.length == 0;
    }

    public static boolean isNotEmpty(byte[] arrays) {
        return arrays != null && arrays.length != 0;
    }

    public static boolean isEmpty(short[] arrays) {
        return arrays == null || arrays.length == 0;
    }

    public static boolean isNotEmpty(short[] arrays) {
        return arrays != null && arrays.length != 0;
    }

    public static boolean isEmpty(int[] arrays) {
        return arrays == null || arrays.length == 0;
    }

    public static boolean isNotEmpty(int[] arrays) {
        return arrays != null && arrays.length != 0;
    }

    public static boolean isEmpty(long[] arrays) {
        return arrays == null || arrays.length == 0;
    }

    public static boolean isNotEmpty(long[] arrays) {
        return arrays != null && arrays.length != 0;
    }

    public static boolean isEmpty(float[] arrays) {
        return arrays == null || arrays.length == 0;
    }

    public static boolean isNotEmpty(float[] arrays) {
        return arrays != null && arrays.length != 0;
    }

    public static boolean isEmpty(double[] arrays) {
        return arrays == null || arrays.length == 0;
    }

    public static boolean isNotEmpty(double[] arrays) {
        return arrays != null && arrays.length != 0;
    }

    public static boolean isEmpty(char[] arrays) {
        return arrays == null || arrays.length == 0;
    }

    public static boolean isNotEmpty(char[] arrays) {
        return arrays != null && arrays.length != 0;
    }

    public static <T> boolean contains(T[] array, T obj) {
        return ArrayUtil.indexOf(array, obj) > -1;
    }

    public static boolean contains(boolean[] array, boolean value) {
        return ArrayUtil.indexOf(array, value) > -1;
    }

    public static boolean contains(byte[] array, byte value) {
        return ArrayUtil.indexOf(array, value) > -1;
    }

    public static boolean contains(short[] array, short value) {
        return ArrayUtil.indexOf(array, value) > -1;
    }

    public static boolean contains(int[] array, int value) {
        return ArrayUtil.indexOf(array, value) > -1;
    }

    public static boolean contains(long[] array, long value) {
        return ArrayUtil.indexOf(array, value) > -1;
    }

    public static boolean contains(float[] array, float value) {
        return ArrayUtil.indexOf(array, value) > -1;
    }

    public static boolean contains(double[] array, double value) {
        return ArrayUtil.indexOf(array, value) > -1;
    }

    public static boolean contains(char[] array, char value) {
        return ArrayUtil.indexOf(array, value) > -1;
    }

    public static <T> boolean equalsIgnoreSequence(T[] array1, T[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        T[] copyOfArray2 = Arrays.copyOf(array2, array2.length);
        for (int i = 0; i < array1.length; ++i) {
            T o1 = array1[i];
            int j = ArrayUtil.indexOf(copyOfArray2, o1, i);
            if (j == -1) {
                return false;
            }
            if (i == j) continue;
            T o2 = copyOfArray2[i];
            copyOfArray2[i] = array2[j];
            copyOfArray2[j] = o2;
        }
        return true;
    }

    public static Object[] toObjectArray(Object array) {
        AssertionUtil.assertArgumentNotNull("array", array);
        AssertionUtil.assertArgument("array", array.getClass().isArray(), MessageFormatter.getSimpleMessage("ECL0104", array));
        int length = Array.getLength(array);
        Object[] objectArray = new Object[length];
        for (int i = 0; i < length; ++i) {
            objectArray[i] = Array.get(array, i);
        }
        return objectArray;
    }

    public static <T> List<T> toList(Object array) {
        AssertionUtil.assertArgumentNotNull("array", array);
        AssertionUtil.assertArgument("array", array.getClass().isArray(), MessageFormatter.getSimpleMessage("ECL0104", array));
        int length = Array.getLength(array);
        ArrayList<Object> list = CollectionsUtil.newArrayList(length);
        for (int i = 0; i < length; ++i) {
            list.add(Array.get(array, i));
        }
        return list;
    }

    public static boolean isArray(Object object) {
        return object != null && object.getClass().isArray();
    }

    public static boolean isNotArray(Object object) {
        return !ArrayUtil.isArray(object);
    }
}

