/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.codelibs.core.exception.ClUnsupportedOperationException;
import org.codelibs.core.misc.AssertionUtil;

public class ArrayIterator<T>
implements Iterator<T> {
    protected final T[] items;
    protected int index = 0;

    public static <T> Iterable<T> iterable(T ... items) {
        AssertionUtil.assertArgumentNotNull("items", items);
        return () -> new ArrayIterator<Object>(items);
    }

    public ArrayIterator(T ... items) {
        this.items = items;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.items.length;
    }

    @Override
    public T next() {
        try {
            T o = this.items[this.index];
            ++this.index;
            return o;
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException("index=" + this.index);
        }
    }

    @Override
    public void remove() {
        throw new ClUnsupportedOperationException("remove");
    }
}

