/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.beans.util;

import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codelibs.core.beans.Converter;
import org.codelibs.core.beans.converter.DateConverter;
import org.codelibs.core.beans.converter.NumberConverter;
import org.codelibs.core.beans.converter.SqlDateConverter;
import org.codelibs.core.beans.converter.TimeConverter;
import org.codelibs.core.beans.converter.TimestampConverter;
import org.codelibs.core.collection.ArrayUtil;
import org.codelibs.core.collection.CollectionsUtil;
import org.codelibs.core.convert.DateConversionUtil;
import org.codelibs.core.convert.TimeConversionUtil;
import org.codelibs.core.convert.TimestampConversionUtil;
import org.codelibs.core.exception.ConverterRuntimeException;
import org.codelibs.core.lang.ClassIterator;
import org.codelibs.core.misc.AssertionUtil;

public class CopyOptions {
    protected static final Converter DEFAULT_DATE_CONVERTER = new DateConverter(DateConversionUtil.getMediumPattern());
    protected static final Converter DEFAULT_TIME_CONVERTER = new DateConverter(TimeConversionUtil.getMediumPattern());
    protected static final Converter DEFAULT_TIMESTAMP_CONVERTER = new DateConverter(TimestampConversionUtil.getMediumPattern());
    protected final List<String> includePropertyNames = CollectionsUtil.newArrayList();
    protected final List<String> excludePropertyNames = CollectionsUtil.newArrayList();
    protected boolean excludesNull = false;
    protected boolean excludesWhitespace = false;
    protected String prefix;
    protected char beanDelimiter = (char)36;
    protected char mapDelimiter = (char)46;
    protected final Map<String, Converter> converterMap = CollectionsUtil.newHashMap();
    protected final List<Converter> converters = CollectionsUtil.newArrayList();

    public CopyOptions include(CharSequence ... propertyNames) {
        AssertionUtil.assertArgumentNotEmpty("propertyNames", propertyNames);
        this.includePropertyNames.addAll(CopyOptions.toStringList(propertyNames));
        return this;
    }

    public CopyOptions exclude(CharSequence ... propertyNames) {
        AssertionUtil.assertArgumentNotEmpty("propertyNames", propertyNames);
        this.excludePropertyNames.addAll(CopyOptions.toStringList(propertyNames));
        return this;
    }

    public CopyOptions excludeNull() {
        this.excludesNull = true;
        return this;
    }

    public CopyOptions excludeWhitespace() {
        this.excludesWhitespace = true;
        return this;
    }

    public CopyOptions prefix(CharSequence prefix) {
        AssertionUtil.assertArgumentNotEmpty("propertyNames", prefix);
        this.prefix = prefix.toString();
        return this;
    }

    public CopyOptions beanDelimiter(char beanDelimiter) {
        this.beanDelimiter = beanDelimiter;
        return this;
    }

    public CopyOptions mapDelimiter(char mapDelimiter) {
        this.mapDelimiter = mapDelimiter;
        return this;
    }

    public CopyOptions converter(Converter converter, CharSequence ... propertyNames) {
        AssertionUtil.assertArgumentNotNull("converter", converter);
        if (ArrayUtil.isEmpty(propertyNames)) {
            this.converters.add(converter);
        } else {
            for (CharSequence name : propertyNames) {
                AssertionUtil.assertArgumentNotEmpty("element of propertyNames", name);
                this.converterMap.put(name.toString(), converter);
            }
        }
        return this;
    }

    public CopyOptions dateConverter(String pattern, CharSequence ... propertyNames) {
        AssertionUtil.assertArgumentNotEmpty("pattern", pattern);
        return this.converter(new DateConverter(pattern), propertyNames);
    }

    public CopyOptions sqlDateConverter(String pattern, CharSequence ... propertyNames) {
        AssertionUtil.assertArgumentNotEmpty("pattern", pattern);
        return this.converter(new SqlDateConverter(pattern), propertyNames);
    }

    public CopyOptions timeConverter(String pattern, CharSequence ... propertyNames) {
        AssertionUtil.assertArgumentNotEmpty("pattern", pattern);
        return this.converter(new TimeConverter(pattern), propertyNames);
    }

    public CopyOptions timestampConverter(String pattern, CharSequence ... propertyNames) {
        AssertionUtil.assertArgumentNotEmpty("pattern", pattern);
        return this.converter(new TimestampConverter(pattern), propertyNames);
    }

    public CopyOptions numberConverter(String pattern, CharSequence ... propertyNames) {
        AssertionUtil.assertArgumentNotEmpty("pattern", pattern);
        return this.converter(new NumberConverter(pattern), propertyNames);
    }

    protected static List<String> toStringList(CharSequence[] array) {
        ArrayList<String> list = CollectionsUtil.newArrayList(array.length);
        for (CharSequence element : array) {
            list.add(element.toString());
        }
        return list;
    }

    protected boolean isTargetProperty(String name) {
        if (this.prefix != null && !name.startsWith(this.prefix)) {
            return false;
        }
        if (!this.includePropertyNames.isEmpty()) {
            for (String includeName : this.includePropertyNames) {
                if (!includeName.equals(name)) continue;
                for (String excludeName : this.excludePropertyNames) {
                    if (!excludeName.equals(name)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (!this.excludePropertyNames.isEmpty()) {
            for (String excludeName : this.excludePropertyNames) {
                if (!excludeName.equals(name)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    protected boolean isTargetValue(Object value) {
        if (value == null) {
            return !this.excludesNull;
        }
        if (value instanceof String && this.excludesWhitespace && ((String)value).trim().isEmpty()) {
            return !this.excludesWhitespace;
        }
        return true;
    }

    protected String toMapDestPropertyName(String srcPropertyName) {
        return this.trimPrefix(srcPropertyName.replace(this.beanDelimiter, this.mapDelimiter));
    }

    protected String toBeanDestPropertyName(String srcPropertyName) {
        return this.trimPrefix(srcPropertyName.replace(this.mapDelimiter, this.beanDelimiter));
    }

    protected String trimPrefix(String propertyName) {
        if (this.prefix == null) {
            return propertyName;
        }
        return propertyName.substring(this.prefix.length());
    }

    protected Object convertValue(Object value, String destPropertyName, Class<?> destPropertyClass) {
        if (value == null || value.getClass() != String.class && destPropertyClass != null && destPropertyClass != String.class) {
            return value;
        }
        Converter converter = this.converterMap.get(destPropertyName);
        if (converter == null) {
            Class<?> clazz;
            Class<?> targetClass = value.getClass() != String.class ? value.getClass() : destPropertyClass;
            if (targetClass == null) {
                return value;
            }
            Iterator<Class<?>> iterator = ClassIterator.iterable(targetClass, false).iterator();
            while (iterator.hasNext() && (converter = this.findConverter(clazz = iterator.next())) == null) {
            }
            if (converter == null && destPropertyClass != null) {
                converter = this.findDefaultConverter(targetClass);
            }
            if (converter == null) {
                return value;
            }
        }
        try {
            if (value.getClass() == String.class) {
                return converter.getAsObject((String)value);
            }
            return converter.getAsString(value);
        }
        catch (Throwable cause) {
            throw new ConverterRuntimeException(destPropertyName, value, cause);
        }
    }

    protected Converter findConverter(Class<?> clazz) {
        for (Converter c : this.converters) {
            if (!c.isTarget(clazz)) continue;
            return c;
        }
        return null;
    }

    protected Converter findDefaultConverter(Class<?> clazz) {
        if (clazz == Date.class) {
            return DEFAULT_DATE_CONVERTER;
        }
        if (clazz == Time.class) {
            return DEFAULT_TIME_CONVERTER;
        }
        if (java.util.Date.class.isAssignableFrom(clazz)) {
            return DEFAULT_TIMESTAMP_CONVERTER;
        }
        return null;
    }
}

