/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.beans.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.codelibs.core.beans.BeanDesc;
import org.codelibs.core.beans.PropertyDesc;
import org.codelibs.core.beans.factory.BeanDescFactory;
import org.codelibs.core.beans.util.CopyOptions;
import org.codelibs.core.collection.CollectionsUtil;
import org.codelibs.core.lang.ClassUtil;
import org.codelibs.core.misc.AssertionUtil;

public abstract class BeanUtil {
    protected static final CopyOptions DEFAULT_OPTIONS = new CopyOptions();

    public static void copyBeanToBean(Object src, Object dest) {
        BeanUtil.copyBeanToBean(src, dest, DEFAULT_OPTIONS);
    }

    public static void copyBeanToBean(Object src, Object dest, Consumer<CopyOptions> option) {
        BeanUtil.copyBeanToBean(src, dest, BeanUtil.buildCopyOptions(option));
    }

    protected static void copyBeanToBean(Object src, Object dest, CopyOptions options) {
        AssertionUtil.assertArgumentNotNull("src", src);
        AssertionUtil.assertArgumentNotNull("dest", dest);
        AssertionUtil.assertArgumentNotNull("option", options);
        BeanDesc srcBeanDesc = BeanDescFactory.getBeanDesc(src.getClass());
        BeanDesc destBeanDesc = BeanDescFactory.getBeanDesc(dest.getClass());
        for (PropertyDesc srcPropertyDesc : srcBeanDesc.getPropertyDescs()) {
            Object value;
            PropertyDesc destPropertyDesc;
            String destPropertyName;
            String srcPropertyName = srcPropertyDesc.getPropertyName();
            if (!srcPropertyDesc.isReadable() || !options.isTargetProperty(srcPropertyName) || !destBeanDesc.hasPropertyDesc(destPropertyName = options.trimPrefix(srcPropertyName)) || !(destPropertyDesc = destBeanDesc.getPropertyDesc(destPropertyName)).isWritable() || !options.isTargetValue(value = srcPropertyDesc.getValue(src))) continue;
            Object convertedValue = options.convertValue(value, destPropertyName, destPropertyDesc.getPropertyType());
            destPropertyDesc.setValue(dest, convertedValue);
        }
    }

    public static void copyBeanToMap(Object src, Map<String, Object> dest) {
        BeanUtil.copyBeanToMap(src, dest, DEFAULT_OPTIONS);
    }

    public static void copyBeanToMap(Object src, Map<String, Object> dest, Consumer<CopyOptions> option) {
        BeanUtil.copyBeanToMap(src, dest, BeanUtil.buildCopyOptions(option));
    }

    protected static void copyBeanToMap(Object src, Map<String, Object> dest, CopyOptions options) {
        AssertionUtil.assertArgumentNotNull("src", src);
        AssertionUtil.assertArgumentNotNull("dest", dest);
        AssertionUtil.assertArgumentNotNull("options", options);
        BeanDesc srcBeanDesc = BeanDescFactory.getBeanDesc(src.getClass());
        for (PropertyDesc srcPropertyDesc : srcBeanDesc.getPropertyDescs()) {
            Object value;
            String srcPropertyName = srcPropertyDesc.getPropertyName();
            if (!srcPropertyDesc.isReadable() || !options.isTargetProperty(srcPropertyName) || !options.isTargetValue(value = srcPropertyDesc.getValue(src))) continue;
            String destPropertyName = options.toMapDestPropertyName(srcPropertyName);
            Object convertedValue = options.convertValue(value, destPropertyName, null);
            dest.put(destPropertyName, convertedValue);
        }
    }

    public static void copyMapToBean(Map<String, ? extends Object> src, Object dest) {
        BeanUtil.copyMapToBean(src, dest, DEFAULT_OPTIONS);
    }

    public static void copyMapToBean(Map<String, ? extends Object> src, Object dest, Consumer<CopyOptions> option) {
        BeanUtil.copyMapToBean(src, dest, BeanUtil.buildCopyOptions(option));
    }

    protected static void copyMapToBean(Map<String, ? extends Object> src, Object dest, CopyOptions options) {
        AssertionUtil.assertArgumentNotNull("src", src);
        AssertionUtil.assertArgumentNotNull("dest", dest);
        AssertionUtil.assertArgumentNotNull("options", options);
        BeanDesc destBeanDesc = BeanDescFactory.getBeanDesc(dest.getClass());
        for (Map.Entry<String, ? extends Object> entry : src.entrySet()) {
            Object value;
            PropertyDesc destPropertyDesc;
            String destPropertyName;
            String srcPropertyName = entry.getKey();
            if (!options.isTargetProperty(srcPropertyName) || !destBeanDesc.hasPropertyDesc(destPropertyName = options.toBeanDestPropertyName(srcPropertyName)) || !(destPropertyDesc = destBeanDesc.getPropertyDesc(destPropertyName)).isWritable() || !options.isTargetValue(value = entry.getValue())) continue;
            Object convertedValue = options.convertValue(value, destPropertyName, destPropertyDesc.getPropertyType());
            destPropertyDesc.setValue(dest, convertedValue);
        }
    }

    public static void copyMapToMap(Map<String, ? extends Object> src, Map<String, Object> dest) {
        BeanUtil.copyMapToMap(src, dest, DEFAULT_OPTIONS);
    }

    public static void copyMapToMap(Map<String, ? extends Object> src, Map<String, Object> dest, Consumer<CopyOptions> option) {
        BeanUtil.copyMapToMap(src, dest, BeanUtil.buildCopyOptions(option));
    }

    protected static void copyMapToMap(Map<String, ? extends Object> src, Map<String, Object> dest, CopyOptions options) {
        AssertionUtil.assertArgumentNotNull("src", src);
        AssertionUtil.assertArgumentNotNull("dest", dest);
        AssertionUtil.assertArgumentNotNull("options", options);
        for (Map.Entry<String, ? extends Object> entry : src.entrySet()) {
            Object value;
            String srcPropertyName = entry.getKey();
            if (!options.isTargetProperty(srcPropertyName) || !options.isTargetValue(value = src.get(srcPropertyName))) continue;
            String destPropertyName = options.trimPrefix(srcPropertyName);
            Object convertedValue = options.convertValue(value, destPropertyName, null);
            dest.put(destPropertyName, convertedValue);
        }
    }

    public static <T> T copyBeanToNewBean(Object src, Class<T> destClass) {
        return BeanUtil.copyBeanToNewBean(src, destClass, DEFAULT_OPTIONS);
    }

    public static <T> T copyBeanToNewBean(Object src, Class<T> destClass, Consumer<CopyOptions> option) {
        return BeanUtil.copyBeanToNewBean(src, destClass, BeanUtil.buildCopyOptions(option));
    }

    protected static <T> T copyBeanToNewBean(Object src, Class<T> destClass, CopyOptions options) {
        AssertionUtil.assertArgumentNotNull("src", src);
        AssertionUtil.assertArgumentNotNull("destClass", destClass);
        AssertionUtil.assertArgumentNotNull("options", options);
        T dest = ClassUtil.newInstance(destClass);
        BeanUtil.copyBeanToBean(src, dest, options);
        return dest;
    }

    public static <T> T copyMapToNewBean(Map<String, ? extends Object> src, Class<T> destClass) {
        return BeanUtil.copyMapToNewBean(src, destClass, DEFAULT_OPTIONS);
    }

    public static <T> T copyMapToNewBean(Map<String, ? extends Object> src, Class<T> destClass, Consumer<CopyOptions> option) {
        return BeanUtil.copyMapToNewBean(src, destClass, BeanUtil.buildCopyOptions(option));
    }

    protected static <T> T copyMapToNewBean(Map<String, ? extends Object> src, Class<T> destClass, CopyOptions options) {
        AssertionUtil.assertArgumentNotNull("src", src);
        AssertionUtil.assertArgumentNotNull("destClass", destClass);
        AssertionUtil.assertArgumentNotNull("options", options);
        T dest = ClassUtil.newInstance(destClass);
        BeanUtil.copyMapToBean(src, dest, options);
        return dest;
    }

    public static Map<String, Object> copyBeanToNewMap(Object src) {
        return BeanUtil.copyBeanToNewMap(src, DEFAULT_OPTIONS);
    }

    public static Map<String, Object> copyBeanToNewMap(Object src, Consumer<CopyOptions> option) {
        return BeanUtil.copyBeanToNewMap(src, BeanUtil.buildCopyOptions(option));
    }

    protected static Map<String, Object> copyBeanToNewMap(Object src, CopyOptions options) {
        AssertionUtil.assertArgumentNotNull("src", src);
        AssertionUtil.assertArgumentNotNull("options", options);
        LinkedHashMap<String, Object> dest = CollectionsUtil.newLinkedHashMap();
        BeanUtil.copyBeanToMap(src, dest, options);
        return dest;
    }

    public static <T extends Map<String, Object>> T copyBeanToNewMap(Object src, Class<? extends T> destClass) {
        return BeanUtil.copyBeanToNewMap(src, destClass, DEFAULT_OPTIONS);
    }

    public static <T extends Map<String, Object>> T copyBeanToNewMap(Object src, Class<? extends T> destClass, Consumer<CopyOptions> option) {
        return BeanUtil.copyBeanToNewMap(src, destClass, BeanUtil.buildCopyOptions(option));
    }

    protected static <T extends Map<String, Object>> T copyBeanToNewMap(Object src, Class<? extends T> destClass, CopyOptions options) {
        AssertionUtil.assertArgumentNotNull("src", src);
        AssertionUtil.assertArgumentNotNull("destClass", destClass);
        AssertionUtil.assertArgumentNotNull("options", options);
        Map dest = (Map)ClassUtil.newInstance(destClass);
        BeanUtil.copyBeanToMap(src, (Map<String, Object>)dest, options);
        return (T)dest;
    }

    public static Map<String, Object> copyMapToNewMap(Map<String, ? extends Object> src) {
        return BeanUtil.copyMapToNewMap(src, DEFAULT_OPTIONS);
    }

    public static Map<String, Object> copyMapToNewMap(Map<String, ? extends Object> src, Consumer<CopyOptions> option) {
        return BeanUtil.copyMapToNewMap(src, BeanUtil.buildCopyOptions(option));
    }

    protected static Map<String, Object> copyMapToNewMap(Map<String, ? extends Object> src, CopyOptions options) {
        AssertionUtil.assertArgumentNotNull("src", src);
        AssertionUtil.assertArgumentNotNull("options", options);
        LinkedHashMap<String, Object> dest = CollectionsUtil.newLinkedHashMap();
        BeanUtil.copyMapToMap(src, dest, options);
        return dest;
    }

    public static <T extends Map<String, Object>> T copyMapToNewMap(Map<String, ? extends Object> src, Class<? extends T> destClass) {
        return BeanUtil.copyMapToNewMap(src, destClass, DEFAULT_OPTIONS);
    }

    public static <T extends Map<String, Object>> T copyMapToNewMap(Map<String, ? extends Object> src, Class<? extends T> destClass, Consumer<CopyOptions> option) {
        return BeanUtil.copyMapToNewMap(src, destClass, BeanUtil.buildCopyOptions(option));
    }

    protected static <T extends Map<String, Object>> T copyMapToNewMap(Map<String, ? extends Object> src, Class<? extends T> destClass, CopyOptions options) {
        AssertionUtil.assertArgumentNotNull("src", src);
        AssertionUtil.assertArgumentNotNull("destClass", destClass);
        AssertionUtil.assertArgumentNotNull("options", options);
        Map dest = (Map)ClassUtil.newInstance(destClass);
        BeanUtil.copyMapToMap(src, (Map<String, Object>)dest, options);
        return (T)dest;
    }

    protected static CopyOptions buildCopyOptions(Consumer<CopyOptions> option) {
        CopyOptions copyOptions = new CopyOptions();
        option.accept(copyOptions);
        return copyOptions;
    }
}

