/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.beans.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import org.codelibs.core.beans.BeanDesc;
import org.codelibs.core.beans.ParameterizedClassDesc;
import org.codelibs.core.beans.PropertyDesc;
import org.codelibs.core.beans.factory.ParameterizedClassDescFactory;
import org.codelibs.core.beans.impl.BeanDescImpl;
import org.codelibs.core.convert.BooleanConversionUtil;
import org.codelibs.core.convert.CalendarConversionUtil;
import org.codelibs.core.convert.DateConversionUtil;
import org.codelibs.core.convert.NumberConversionUtil;
import org.codelibs.core.convert.TimeConversionUtil;
import org.codelibs.core.convert.TimestampConversionUtil;
import org.codelibs.core.exception.ClIllegalArgumentException;
import org.codelibs.core.exception.IllegalPropertyRuntimeException;
import org.codelibs.core.exception.ParseRuntimeException;
import org.codelibs.core.lang.ConstructorUtil;
import org.codelibs.core.lang.FieldUtil;
import org.codelibs.core.lang.MethodUtil;
import org.codelibs.core.lang.ModifierUtil;
import org.codelibs.core.misc.AssertionUtil;

public class PropertyDescImpl
implements PropertyDesc {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private final String propertyName;
    private final Class<?> propertyType;
    private Method readMethod;
    private Method writeMethod;
    private Field field;
    private final BeanDesc beanDesc;
    private Constructor<?> stringConstructor;
    private Method valueOfMethod;
    private boolean readable = false;
    private boolean writable = false;
    private ParameterizedClassDesc parameterizedClassDesc;

    public PropertyDescImpl(String propertyName, Class<?> propertyType, Method readMethod, Method writeMethod, BeanDesc beanDesc) {
        this(propertyName, propertyType, readMethod, writeMethod, null, beanDesc);
    }

    public PropertyDescImpl(String propertyName, Class<?> propertyType, Method readMethod, Method writeMethod, Field field, BeanDesc beanDesc) {
        AssertionUtil.assertArgumentNotEmpty("propertyName", propertyName);
        AssertionUtil.assertArgumentNotNull("propertyType", propertyType);
        AssertionUtil.assertArgumentNotNull("beanDesc", beanDesc);
        this.propertyName = propertyName;
        this.propertyType = propertyType;
        this.setReadMethod(readMethod);
        this.setWriteMethod(writeMethod);
        this.setField(field);
        this.beanDesc = beanDesc;
        this.setupStringConstructor();
        this.setupValueOfMethod();
        this.setUpParameterizedClassDesc();
    }

    private void setupStringConstructor() {
        for (Constructor<?> con : this.propertyType.getConstructors()) {
            if (con.getParameterTypes().length != 1 || !con.getParameterTypes()[0].equals(String.class)) continue;
            this.stringConstructor = con;
            break;
        }
    }

    private void setupValueOfMethod() {
        for (Method method : this.propertyType.getMethods()) {
            if (method.isBridge() || method.isSynthetic() || !ModifierUtil.isStatic(method.getModifiers()) || !method.getName().equals("valueOf") || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(String.class)) continue;
            this.valueOfMethod = method;
            break;
        }
    }

    private void setUpParameterizedClassDesc() {
        Map<TypeVariable<?>, Type> typeVariables = ((BeanDescImpl)this.beanDesc).getTypeVariables();
        if (this.field != null) {
            this.parameterizedClassDesc = ParameterizedClassDescFactory.createParameterizedClassDesc(this.field, typeVariables);
        } else if (this.readMethod != null) {
            this.parameterizedClassDesc = ParameterizedClassDescFactory.createParameterizedClassDesc(this.readMethod, typeVariables);
        } else if (this.writeMethod != null) {
            this.parameterizedClassDesc = ParameterizedClassDescFactory.createParameterizedClassDesc(this.writeMethod, 0, typeVariables);
        }
    }

    @Override
    public final String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public final <T> Class<T> getPropertyType() {
        return this.propertyType;
    }

    @Override
    public final Method getReadMethod() {
        return this.readMethod;
    }

    protected final void setReadMethod(Method readMethod) {
        this.readMethod = readMethod;
        if (readMethod != null) {
            this.readable = true;
            readMethod.setAccessible(true);
        }
    }

    @Override
    public final boolean hasReadMethod() {
        return this.readMethod != null;
    }

    @Override
    public final Method getWriteMethod() {
        return this.writeMethod;
    }

    protected final void setWriteMethod(Method writeMethod) {
        this.writeMethod = writeMethod;
        if (writeMethod != null) {
            this.writable = true;
            writeMethod.setAccessible(true);
        }
    }

    @Override
    public final boolean hasWriteMethod() {
        return this.writeMethod != null;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
        if (field != null && ModifierUtil.isPublic(field)) {
            this.readable = true;
            this.writable = true;
        }
    }

    @Override
    public boolean isReadable() {
        return this.readable;
    }

    @Override
    public boolean isWritable() {
        return this.writable;
    }

    @Override
    public <T> T getValue(Object target) {
        AssertionUtil.assertArgumentNotNull("target", target);
        try {
            AssertionUtil.assertState(this.readable, this.propertyName + " is not readable.");
            if (this.hasReadMethod()) {
                return MethodUtil.invoke(this.readMethod, target, EMPTY_ARGS);
            }
            return FieldUtil.get(this.field, target);
        }
        catch (Throwable t) {
            throw new IllegalPropertyRuntimeException(this.beanDesc.getBeanClass(), this.propertyName, t);
        }
    }

    @Override
    public void setValue(Object target, Object value) {
        block5: {
            AssertionUtil.assertArgumentNotNull("target", target);
            try {
                Object convertedValue = this.convertIfNeed(value);
                AssertionUtil.assertState(this.writable, this.propertyName + " is not writable.");
                if (this.hasWriteMethod()) {
                    try {
                        MethodUtil.invoke(this.writeMethod, target, convertedValue);
                        break block5;
                    }
                    catch (Throwable t) {
                        Class<?> clazz = this.writeMethod.getDeclaringClass();
                        Class<?> valueClass = convertedValue == null ? null : convertedValue.getClass();
                        Class<?> targetClass = target == null ? null : target.getClass();
                        throw new ClIllegalArgumentException("target", "ECL0098", new Object[]{clazz.getName(), clazz.getClassLoader(), this.propertyType.getName(), this.propertyType.getClassLoader(), this.propertyName, valueClass == null ? null : valueClass.getName(), valueClass == null ? null : valueClass.getClassLoader(), convertedValue, targetClass == null ? null : targetClass.getName(), targetClass == null ? null : targetClass.getClassLoader()}).initCause(t);
                    }
                }
                FieldUtil.set(this.field, target, convertedValue);
            }
            catch (Throwable t) {
                throw new IllegalPropertyRuntimeException(this.beanDesc.getBeanClass(), this.propertyName, t);
            }
        }
    }

    @Override
    public BeanDesc getBeanDesc() {
        return this.beanDesc;
    }

    public final String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("propertyName=").append(this.propertyName).append(",propertyType=").append(this.propertyType.getName()).append(",readMethod=").append(this.readMethod != null ? this.readMethod.getName() : "null").append(",writeMethod=").append(this.writeMethod != null ? this.writeMethod.getName() : "null");
        return new String(buf);
    }

    @Override
    public <T> T convertIfNeed(Object arg) {
        if (this.propertyType.isPrimitive()) {
            return (T)this.convertPrimitiveWrapper(arg);
        }
        if (Number.class.isAssignableFrom(this.propertyType)) {
            return (T)this.convertNumber(arg);
        }
        if (java.util.Date.class.isAssignableFrom(this.propertyType)) {
            return (T)this.convertDate(arg);
        }
        if (Boolean.class.isAssignableFrom(this.propertyType)) {
            return (T)BooleanConversionUtil.toBoolean(arg);
        }
        if (arg != null && arg.getClass() != String.class && String.class == this.propertyType) {
            return (T)arg.toString();
        }
        if (arg instanceof String && !String.class.equals(this.propertyType)) {
            return (T)this.convertWithString(arg);
        }
        if (Calendar.class.isAssignableFrom(this.propertyType)) {
            return (T)CalendarConversionUtil.toCalendar(arg);
        }
        return (T)arg;
    }

    private Object convertPrimitiveWrapper(Object arg) {
        return NumberConversionUtil.convertPrimitiveWrapper(this.propertyType, arg);
    }

    private Object convertNumber(Object arg) {
        return NumberConversionUtil.convertNumber(this.propertyType, arg);
    }

    private Object convertDate(Object arg) {
        if (this.propertyType == java.util.Date.class) {
            try {
                return TimestampConversionUtil.toDate(arg);
            }
            catch (ParseRuntimeException ex) {
                try {
                    return DateConversionUtil.toDate(arg);
                }
                catch (ParseRuntimeException ex2) {
                    return TimeConversionUtil.toDate(arg);
                }
            }
        }
        if (this.propertyType == Timestamp.class) {
            return TimestampConversionUtil.toSqlTimestamp(arg);
        }
        if (this.propertyType == Date.class) {
            return DateConversionUtil.toSqlDate(arg);
        }
        if (this.propertyType == Time.class) {
            return TimeConversionUtil.toSqlTime(arg);
        }
        return arg;
    }

    private Object convertWithString(Object arg) {
        if (this.stringConstructor != null) {
            return ConstructorUtil.newInstance(this.stringConstructor, arg);
        }
        if (this.valueOfMethod != null) {
            return MethodUtil.invoke(this.valueOfMethod, null, arg);
        }
        return arg;
    }

    @Override
    public boolean isParameterized() {
        return this.parameterizedClassDesc != null && this.parameterizedClassDesc.isParameterizedClass();
    }

    @Override
    public ParameterizedClassDesc getParameterizedClassDesc() {
        return this.parameterizedClassDesc;
    }

    @Override
    public Class<?> getElementClassOfCollection() {
        if (!Collection.class.isAssignableFrom(this.propertyType) || !this.isParameterized()) {
            return null;
        }
        ParameterizedClassDesc pcd = this.parameterizedClassDesc.getArguments()[0];
        if (pcd == null) {
            return null;
        }
        return pcd.getRawClass();
    }

    @Override
    public Class<?> getKeyClassOfMap() {
        if (!Map.class.isAssignableFrom(this.propertyType) || !this.isParameterized()) {
            return null;
        }
        ParameterizedClassDesc pcd = this.parameterizedClassDesc.getArguments()[0];
        if (pcd == null) {
            return null;
        }
        return pcd.getRawClass();
    }

    @Override
    public Class<?> getValueClassOfMap() {
        if (!Map.class.isAssignableFrom(this.propertyType) || !this.isParameterized()) {
            return null;
        }
        ParameterizedClassDesc pcd = this.parameterizedClassDesc.getArguments()[1];
        if (pcd == null) {
            return null;
        }
        return pcd.getRawClass();
    }
}

