/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.beans.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Map;
import org.codelibs.core.beans.BeanDesc;
import org.codelibs.core.beans.ConstructorDesc;
import org.codelibs.core.beans.ParameterizedClassDesc;
import org.codelibs.core.beans.factory.ParameterizedClassDescFactory;
import org.codelibs.core.lang.ConstructorUtil;
import org.codelibs.core.misc.AssertionUtil;

public class ConstructorDescImpl
implements ConstructorDesc {
    protected final BeanDesc beanDesc;
    protected final Constructor<?> constructor;
    protected final Class<?>[] parameterTypes;
    protected final ParameterizedClassDesc[] parameterizedClassDescs;

    public ConstructorDescImpl(BeanDesc beanDesc, Constructor<?> constructor) {
        AssertionUtil.assertArgumentNotNull("beanDesc", beanDesc);
        AssertionUtil.assertArgumentNotNull("constructor", constructor);
        this.beanDesc = beanDesc;
        this.constructor = constructor;
        this.parameterTypes = constructor.getParameterTypes();
        this.parameterizedClassDescs = new ParameterizedClassDesc[this.parameterTypes.length];
        Map<TypeVariable<?>, Type> typeVariables = beanDesc.getTypeVariables();
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            this.parameterizedClassDescs[i] = ParameterizedClassDescFactory.createParameterizedClassDesc(constructor, i, typeVariables);
        }
    }

    @Override
    public BeanDesc getBeanDesc() {
        return this.beanDesc;
    }

    @Override
    public <T> Constructor<T> getConstructor() {
        return this.constructor;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public boolean isPublic() {
        return ConstructorUtil.isPublic(this.constructor);
    }

    @Override
    public boolean isParameterized(int index) {
        AssertionUtil.assertArgumentArrayIndex("index", index, this.parameterTypes.length);
        return this.parameterizedClassDescs[index].isParameterizedClass();
    }

    @Override
    public ParameterizedClassDesc[] getParameterizedClassDescs() {
        return this.parameterizedClassDescs;
    }

    @Override
    public Class<?> getElementClassOfCollection(int index) {
        AssertionUtil.assertArgumentArrayIndex("index", index, this.parameterTypes.length);
        if (!Collection.class.isAssignableFrom(this.parameterTypes[index]) || !this.isParameterized(index)) {
            return null;
        }
        ParameterizedClassDesc pcd = this.parameterizedClassDescs[index].getArguments()[0];
        if (pcd == null) {
            return null;
        }
        return pcd.getRawClass();
    }

    @Override
    public Class<?> getKeyClassOfMap(int index) {
        AssertionUtil.assertArgumentArrayIndex("index", index, this.parameterTypes.length);
        if (!Map.class.isAssignableFrom(this.parameterTypes[index]) || !this.isParameterized(index)) {
            return null;
        }
        ParameterizedClassDesc pcd = this.parameterizedClassDescs[index].getArguments()[0];
        if (pcd == null) {
            return null;
        }
        return pcd.getRawClass();
    }

    @Override
    public Class<?> getValueClassOfMap(int index) {
        AssertionUtil.assertArgumentArrayIndex("index", index, this.parameterTypes.length);
        if (!Map.class.isAssignableFrom(this.parameterTypes[index]) || !this.isParameterized(index)) {
            return null;
        }
        ParameterizedClassDesc pcd = this.parameterizedClassDescs[index].getArguments()[1];
        if (pcd == null) {
            return null;
        }
        return pcd.getRawClass();
    }

    @Override
    public <T> T newInstance(Object ... args) {
        return (T)ConstructorUtil.newInstance(this.constructor, args);
    }
}

