/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.beans.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codelibs.core.beans.BeanDesc;
import org.codelibs.core.beans.ConstructorDesc;
import org.codelibs.core.beans.FieldDesc;
import org.codelibs.core.beans.MethodDesc;
import org.codelibs.core.beans.ParameterizedClassDesc;
import org.codelibs.core.beans.PropertyDesc;
import org.codelibs.core.beans.impl.ConstructorDescImpl;
import org.codelibs.core.beans.impl.FieldDescImpl;
import org.codelibs.core.beans.impl.MethodDescImpl;
import org.codelibs.core.beans.impl.ParameterizedClassDescImpl;
import org.codelibs.core.beans.impl.PropertyDescImpl;
import org.codelibs.core.collection.ArrayMap;
import org.codelibs.core.collection.CaseInsensitiveMap;
import org.codelibs.core.collection.CollectionsUtil;
import org.codelibs.core.convert.ByteConversionUtil;
import org.codelibs.core.convert.DoubleConversionUtil;
import org.codelibs.core.convert.FloatConversionUtil;
import org.codelibs.core.convert.IntegerConversionUtil;
import org.codelibs.core.convert.LongConversionUtil;
import org.codelibs.core.convert.ShortConversionUtil;
import org.codelibs.core.exception.ConstructorNotFoundRuntimeException;
import org.codelibs.core.exception.FieldNotFoundRuntimeException;
import org.codelibs.core.exception.MethodNotFoundRuntimeException;
import org.codelibs.core.exception.PropertyNotFoundRuntimeException;
import org.codelibs.core.lang.ClassUtil;
import org.codelibs.core.lang.FieldUtil;
import org.codelibs.core.lang.GenericsUtil;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.misc.AssertionUtil;

public class BeanDescImpl
implements BeanDesc {
    protected static final Object[] EMPTY_ARGS = new Object[0];
    protected static final Class<?>[] EMPTY_PARAM_TYPES = new Class[0];
    protected final Class<?> beanClass;
    protected final Map<TypeVariable<?>, Type> typeVariables;
    protected final CaseInsensitiveMap<PropertyDesc> propertyDescCache = new CaseInsensitiveMap();
    protected final ArrayMap<String, FieldDesc> fieldDescCache = new ArrayMap();
    protected final List<ConstructorDesc> constructorDescs = CollectionsUtil.newArrayList();
    protected final Map<String, MethodDesc[]> methodDescsCache = CollectionsUtil.newHashMap();
    protected final Set<String> invalidPropertyNames = CollectionsUtil.newHashSet();

    public BeanDescImpl(Class<?> beanClass) {
        AssertionUtil.assertArgumentNotNull("beanClass", beanClass);
        this.beanClass = beanClass;
        this.typeVariables = GenericsUtil.getTypeVariableMap(beanClass);
        this.setupConstructorDescs();
        this.setupPropertyDescs();
        this.setupMethodDescs();
        this.setupFieldDescs();
    }

    @Override
    public <T> Class<T> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public Map<TypeVariable<?>, Type> getTypeVariables() {
        return this.typeVariables;
    }

    @Override
    public boolean hasPropertyDesc(String propertyName) {
        AssertionUtil.assertArgumentNotEmpty("propertyName", propertyName);
        return this.propertyDescCache.get(propertyName) != null;
    }

    @Override
    public PropertyDesc getPropertyDesc(String propertyName) throws PropertyNotFoundRuntimeException {
        AssertionUtil.assertArgumentNotEmpty("propertyName", propertyName);
        PropertyDesc pd = this.propertyDescCache.get(propertyName);
        if (pd == null) {
            throw new PropertyNotFoundRuntimeException(this.beanClass, propertyName);
        }
        return pd;
    }

    @Override
    public PropertyDesc getPropertyDesc(int index) {
        AssertionUtil.assertArgumentArrayIndex("index", index, this.getPropertyDescSize());
        return (PropertyDesc)this.propertyDescCache.getAt(index);
    }

    @Override
    public int getPropertyDescSize() {
        return this.propertyDescCache.size();
    }

    @Override
    public Iterable<PropertyDesc> getPropertyDescs() {
        return Collections.unmodifiableCollection(this.propertyDescCache.values());
    }

    @Override
    public boolean hasFieldDesc(String fieldName) {
        AssertionUtil.assertArgumentNotEmpty("fieldName", fieldName);
        return this.fieldDescCache.containsKey(fieldName);
    }

    @Override
    public FieldDesc getFieldDesc(String fieldName) {
        AssertionUtil.assertArgumentNotEmpty("fieldName", fieldName);
        FieldDesc fieldDesc = this.fieldDescCache.get(fieldName);
        if (fieldDesc == null) {
            throw new FieldNotFoundRuntimeException(this.beanClass, fieldName);
        }
        return fieldDesc;
    }

    @Override
    public FieldDesc getFieldDesc(int index) {
        AssertionUtil.assertArgumentArrayIndex("index", index, this.getFieldDescSize());
        return this.fieldDescCache.getAt(index);
    }

    @Override
    public int getFieldDescSize() {
        return this.fieldDescCache.size();
    }

    @Override
    public Iterable<FieldDesc> getFieldDescs() {
        return Collections.unmodifiableCollection(this.fieldDescCache.values());
    }

    @Override
    public <T> T newInstance(Object ... args) {
        ConstructorDesc constructorDesc = this.getSuitableConstructorDesc(args);
        return constructorDesc.newInstance(args);
    }

    @Override
    public ConstructorDesc getConstructorDesc(Class<?> ... paramTypes) {
        for (ConstructorDesc constructorDesc : this.constructorDescs) {
            if (!Arrays.equals(paramTypes, constructorDesc.getParameterTypes())) continue;
            return constructorDesc;
        }
        throw new ConstructorNotFoundRuntimeException(this.beanClass, paramTypes);
    }

    @Override
    public ConstructorDesc getSuitableConstructorDesc(Object ... args) {
        ConstructorDesc constructorDesc = this.findSuitableConstructorDesc(args);
        if (constructorDesc != null) {
            return constructorDesc;
        }
        constructorDesc = this.findSuitableConstructorDescAdjustNumber(args);
        if (constructorDesc != null) {
            return constructorDesc;
        }
        throw new ConstructorNotFoundRuntimeException(this.beanClass, args);
    }

    @Override
    public ConstructorDesc getConstructorDesc(int index) {
        return this.constructorDescs.get(index);
    }

    @Override
    public int getConstructorDescSize() {
        return this.constructorDescs.size();
    }

    @Override
    public Iterable<ConstructorDesc> getConstructorDescs() {
        return Collections.unmodifiableCollection(this.constructorDescs);
    }

    @Override
    public MethodDesc getMethodDesc(String methodName, Class<?> ... paramTypes) {
        AssertionUtil.assertArgumentNotEmpty("methodName", methodName);
        MethodDesc methodDesc = this.getMethodDescNoException(methodName, paramTypes);
        if (methodDesc != null) {
            return methodDesc;
        }
        throw new MethodNotFoundRuntimeException(this.beanClass, methodName, paramTypes);
    }

    @Override
    public MethodDesc getMethodDescNoException(String methodName, Class<?> ... paramTypes) {
        AssertionUtil.assertArgumentNotEmpty("methodName", methodName);
        MethodDesc[] methodDescs = this.methodDescsCache.get(methodName);
        if (methodDescs == null) {
            return null;
        }
        for (MethodDesc methodDesc : methodDescs) {
            if (!Arrays.equals(paramTypes, methodDesc.getParameterTypes())) continue;
            return methodDesc;
        }
        return null;
    }

    @Override
    public MethodDesc getSuitableMethodDesc(String methodName, Object ... args) {
        AssertionUtil.assertArgumentNotEmpty("methodName", methodName);
        MethodDesc[] methodDescs = this.getMethodDescs(methodName);
        MethodDesc methodDesc = this.findSuitableMethod(methodDescs, args);
        if (methodDesc != null) {
            return methodDesc;
        }
        methodDesc = this.findSuitableMethodDescAdjustNumber(methodDescs, args);
        if (methodDesc != null) {
            return methodDesc;
        }
        throw new MethodNotFoundRuntimeException(this.beanClass, methodName, args);
    }

    @Override
    public MethodDesc[] getMethodDescs(String methodName) {
        AssertionUtil.assertArgumentNotEmpty("methodName", methodName);
        MethodDesc[] methodDescs = this.methodDescsCache.get(methodName);
        if (methodDescs == null) {
            throw new MethodNotFoundRuntimeException(this.beanClass, methodName, null);
        }
        return methodDescs;
    }

    @Override
    public boolean hasMethodDesc(String methodName) {
        AssertionUtil.assertArgumentNotEmpty("methodName", methodName);
        return this.methodDescsCache.containsKey(methodName);
    }

    @Override
    public String[] getMethodNames() {
        return this.methodDescsCache.keySet().toArray(new String[this.methodDescsCache.size()]);
    }

    protected PropertyDesc getPropertyDescNoException(String propertyName) {
        return this.propertyDescCache.get(propertyName);
    }

    protected ConstructorDesc findSuitableConstructorDesc(Object ... args) {
        for (ConstructorDesc constructorDesc : this.constructorDescs) {
            if (!this.isSuitable(constructorDesc.getParameterTypes(), args, false)) continue;
            return constructorDesc;
        }
        return null;
    }

    protected ConstructorDesc findSuitableConstructorDescAdjustNumber(Object ... args) {
        for (ConstructorDesc constructorDesc : this.constructorDescs) {
            if (!this.isSuitable(constructorDesc.getParameterTypes(), args, true)) continue;
            return constructorDesc;
        }
        return null;
    }

    protected MethodDesc findSuitableMethod(MethodDesc[] methodDescs, Object[] args) {
        for (MethodDesc methodDesc : methodDescs) {
            if (!this.isSuitable(methodDesc.getParameterTypes(), args, false)) continue;
            return methodDesc;
        }
        return null;
    }

    protected MethodDesc findSuitableMethodDescAdjustNumber(MethodDesc[] methodDescs, Object[] args) {
        for (MethodDesc methodDesc : methodDescs) {
            if (!this.isSuitable(methodDesc.getParameterTypes(), args, true)) continue;
            return methodDesc;
        }
        return null;
    }

    protected boolean isSuitable(Class<?>[] paramTypes, Object[] args, boolean adjustNumber) {
        if (args == null) {
            return paramTypes.length == 0;
        }
        if (paramTypes.length != args.length) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || ClassUtil.isAssignableFrom(paramTypes[i], args[i].getClass()) || adjustNumber && BeanDescImpl.adjustNumber(paramTypes, args, i)) continue;
            return false;
        }
        return true;
    }

    protected static boolean adjustNumber(Class<?>[] paramTypes, Object[] args, int index) {
        if (paramTypes[index].isPrimitive()) {
            if (paramTypes[index] == Byte.TYPE) {
                args[index] = ByteConversionUtil.toByte(args[index]);
                return true;
            }
            if (paramTypes[index] == Short.TYPE) {
                args[index] = ShortConversionUtil.toShort(args[index]);
                return true;
            }
            if (paramTypes[index] == Integer.TYPE) {
                args[index] = IntegerConversionUtil.toInteger(args[index]);
                return true;
            }
            if (paramTypes[index] == Long.TYPE) {
                args[index] = LongConversionUtil.toLong(args[index]);
                return true;
            }
            if (paramTypes[index] == Float.TYPE) {
                args[index] = FloatConversionUtil.toFloat(args[index]);
                return true;
            }
            if (paramTypes[index] == Double.TYPE) {
                args[index] = DoubleConversionUtil.toDouble(args[index]);
                return true;
            }
        } else {
            if (paramTypes[index] == Byte.class) {
                args[index] = ByteConversionUtil.toByte(args[index]);
                return true;
            }
            if (paramTypes[index] == Short.class) {
                args[index] = ShortConversionUtil.toShort(args[index]);
                return true;
            }
            if (paramTypes[index] == Integer.class) {
                args[index] = IntegerConversionUtil.toInteger(args[index]);
                return true;
            }
            if (paramTypes[index] == Long.class) {
                args[index] = LongConversionUtil.toLong(args[index]);
                return true;
            }
            if (paramTypes[index] == Float.class) {
                args[index] = FloatConversionUtil.toFloat(args[index]);
                return true;
            }
            if (paramTypes[index] == Double.class) {
                args[index] = DoubleConversionUtil.toDouble(args[index]);
                return true;
            }
        }
        return false;
    }

    protected void setupPropertyDescs() {
        for (Method m : this.beanClass.getMethods()) {
            String propertyName;
            if (m.isBridge() || m.isSynthetic()) continue;
            String methodName = m.getName();
            if (methodName.startsWith("get")) {
                if (m.getParameterTypes().length != 0 || methodName.equals("getClass") || m.getReturnType() == Void.TYPE) continue;
                propertyName = StringUtil.decapitalize(methodName.substring(3));
                this.setupReadMethod(m, propertyName);
                continue;
            }
            if (methodName.startsWith("is")) {
                if (m.getParameterTypes().length != 0 || !m.getReturnType().equals(Boolean.TYPE) && !m.getReturnType().equals(Boolean.class)) continue;
                propertyName = StringUtil.decapitalize(methodName.substring(2));
                this.setupReadMethod(m, propertyName);
                continue;
            }
            if (!methodName.startsWith("set") || m.getParameterTypes().length != 1 || methodName.equals("setClass") || m.getReturnType() != Void.TYPE) continue;
            propertyName = StringUtil.decapitalize(methodName.substring(3));
            this.setupWriteMethod(m, propertyName);
        }
        for (String name : this.invalidPropertyNames) {
            this.propertyDescCache.remove(name);
        }
        this.invalidPropertyNames.clear();
    }

    protected void setupReadMethod(Method readMethod, String propertyName) {
        Class<?> propertyType = readMethod.getReturnType();
        PropertyDescImpl propDesc = (PropertyDescImpl)this.propertyDescCache.get(propertyName);
        if (propDesc == null) {
            propDesc = new PropertyDescImpl(propertyName, propertyType, readMethod, null, null, this);
            this.addPropertyDesc(propDesc);
        } else if (propDesc.getPropertyType() != propertyType) {
            this.invalidPropertyNames.add(propertyName);
        } else {
            propDesc.setReadMethod(readMethod);
        }
    }

    protected void setupWriteMethod(Method writeMethod, String propertyName) {
        Class<?> propertyType = writeMethod.getParameterTypes()[0];
        PropertyDescImpl propDesc = (PropertyDescImpl)this.propertyDescCache.get(propertyName);
        if (propDesc == null) {
            propDesc = new PropertyDescImpl(propertyName, propertyType, null, writeMethod, null, this);
            this.addPropertyDesc(propDesc);
        } else if (propDesc.getPropertyType() != propertyType) {
            this.invalidPropertyNames.add(propertyName);
        } else {
            propDesc.setWriteMethod(writeMethod);
        }
    }

    protected void addPropertyDesc(PropertyDescImpl propertyDesc) {
        AssertionUtil.assertArgumentNotNull("propertyDesc", propertyDesc);
        this.propertyDescCache.put(propertyDesc.getPropertyName(), (PropertyDesc)propertyDesc);
    }

    protected void setupConstructorDescs() {
        for (Constructor<?> constructor : this.beanClass.getConstructors()) {
            this.constructorDescs.add(new ConstructorDescImpl(this, constructor));
        }
    }

    protected void setupMethodDescs() {
        ArrayMap<String, ArrayList<MethodDescImpl>> methodDescListMap = new ArrayMap<String, ArrayList<MethodDescImpl>>();
        for (Method method : this.beanClass.getMethods()) {
            if (method.isBridge() || method.isSynthetic()) continue;
            String methodName = method.getName();
            ArrayList<MethodDescImpl> list = (ArrayList<MethodDescImpl>)methodDescListMap.get(methodName);
            if (list == null) {
                list = CollectionsUtil.newArrayList();
                methodDescListMap.put(methodName, list);
            }
            list.add(new MethodDescImpl(this, method));
        }
        for (int i = 0; i < methodDescListMap.size(); ++i) {
            List methodDescList = (List)methodDescListMap.getAt(i);
            this.methodDescsCache.put((String)methodDescListMap.getKeyAt(i), methodDescList.toArray(new MethodDesc[methodDescList.size()]));
        }
    }

    protected void setupFieldDescs() {
        if (this.beanClass.isInterface()) {
            this.setupFieldDescsByInterface(this.beanClass);
        } else {
            this.setupFieldDescsByClass(this.beanClass);
        }
    }

    protected void setupFieldDescsByInterface(Class<?> interfaceClass) {
        Class<?>[] interfaces;
        this.addFieldDescs(interfaceClass);
        for (Class<?> intf : interfaces = interfaceClass.getInterfaces()) {
            this.setupFieldDescsByInterface(intf);
        }
    }

    private void setupFieldDescsByClass(Class<?> targetClass) {
        this.addFieldDescs(targetClass);
        for (Class<?> intf : targetClass.getInterfaces()) {
            this.setupFieldDescsByInterface(intf);
        }
        Class<?> superClass = targetClass.getSuperclass();
        if (superClass != Object.class && superClass != null) {
            this.setupFieldDescsByClass(superClass);
        }
    }

    protected void addFieldDescs(Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            PropertyDescImpl pd;
            String fname = field.getName();
            if (this.fieldDescCache.containsKey(fname)) continue;
            field.setAccessible(true);
            FieldDescImpl fieldDesc = new FieldDescImpl(this, field);
            this.fieldDescCache.put(fname, fieldDesc);
            if (!FieldUtil.isInstanceField(field)) continue;
            if (this.hasPropertyDesc(fname)) {
                pd = (PropertyDescImpl)this.propertyDescCache.get(field.getName());
                pd.setField(field);
                continue;
            }
            if (!FieldUtil.isPublicField(field)) continue;
            pd = new PropertyDescImpl(field.getName(), field.getType(), null, null, field, this);
            this.propertyDescCache.put(fname, (PropertyDesc)pd);
        }
    }

    protected static ParameterizedClassDesc createParameterizedClassDesc(Type type, Map<TypeVariable<?>, Type> map) {
        Class<?> rowClass = GenericsUtil.getActualClass(type, map);
        if (rowClass == null) {
            return null;
        }
        ParameterizedClassDescImpl desc = new ParameterizedClassDescImpl(rowClass);
        Type[] parameterTypes = GenericsUtil.getGenericParameters(type);
        if (parameterTypes == null) {
            return desc;
        }
        ParameterizedClassDesc[] parameterDescs = new ParameterizedClassDesc[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterDescs[i] = BeanDescImpl.createParameterizedClassDesc(parameterTypes[i], map);
        }
        desc.setArguments(parameterDescs);
        return desc;
    }
}

