/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.beans.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.codelibs.core.beans.ParameterizedClassDesc;
import org.codelibs.core.beans.impl.ParameterizedClassDescImpl;
import org.codelibs.core.collection.ArrayIterator;
import org.codelibs.core.collection.Indexed;
import org.codelibs.core.collection.IndexedIterator;
import org.codelibs.core.lang.GenericsUtil;
import org.codelibs.core.misc.AssertionUtil;

public abstract class ParameterizedClassDescFactory {
    public static Map<TypeVariable<?>, Type> getTypeVariables(Class<?> beanClass) {
        AssertionUtil.assertArgumentNotNull("beanClass", beanClass);
        return GenericsUtil.getTypeVariableMap(beanClass);
    }

    public static ParameterizedClassDesc createParameterizedClassDesc(Field field, Map<TypeVariable<?>, Type> map) {
        AssertionUtil.assertArgumentNotNull("field", field);
        AssertionUtil.assertArgumentNotNull("map", map);
        return ParameterizedClassDescFactory.createParameterizedClassDesc(field.getGenericType(), map);
    }

    public static ParameterizedClassDesc createParameterizedClassDesc(Constructor<?> constructor, int index, Map<TypeVariable<?>, Type> map) {
        AssertionUtil.assertArgumentNotNull("constructor", constructor);
        AssertionUtil.assertArgumentNotNull("map", map);
        return ParameterizedClassDescFactory.createParameterizedClassDesc(constructor.getGenericParameterTypes()[index], map);
    }

    public static ParameterizedClassDesc createParameterizedClassDesc(Method method, int index, Map<TypeVariable<?>, Type> map) {
        AssertionUtil.assertArgumentNotNull("method", method);
        AssertionUtil.assertArgumentArrayIndex("index", index, method.getParameterTypes().length);
        AssertionUtil.assertArgumentNotNull("map", map);
        return ParameterizedClassDescFactory.createParameterizedClassDesc(method.getGenericParameterTypes()[index], map);
    }

    public static ParameterizedClassDesc createParameterizedClassDesc(Method method, Map<TypeVariable<?>, Type> map) {
        AssertionUtil.assertArgumentNotNull("method", method);
        AssertionUtil.assertArgumentNotNull("map", map);
        return ParameterizedClassDescFactory.createParameterizedClassDesc(method.getGenericReturnType(), map);
    }

    protected static ParameterizedClassDesc createParameterizedClassDesc(Type type, Map<TypeVariable<?>, Type> map) {
        Class<?> rowClass = GenericsUtil.getActualClass(type, map);
        if (rowClass == null) {
            return null;
        }
        ParameterizedClassDescImpl desc = new ParameterizedClassDescImpl(rowClass);
        Type[] parameterTypes = GenericsUtil.getGenericParameters(type);
        if (parameterTypes == null) {
            return desc;
        }
        ParameterizedClassDesc[] parameterDescs = new ParameterizedClassDesc[parameterTypes.length];
        for (Indexed<Type> parameterType : IndexedIterator.indexed(ArrayIterator.iterable(parameterTypes))) {
            parameterDescs[parameterType.getIndex()] = ParameterizedClassDescFactory.createParameterizedClassDesc(parameterType.getElement(), map);
        }
        desc.setArguments(parameterDescs);
        return desc;
    }
}

