/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.beans.factory;

import java.util.concurrent.ConcurrentMap;
import org.codelibs.core.beans.BeanDesc;
import org.codelibs.core.beans.impl.BeanDescImpl;
import org.codelibs.core.collection.CollectionsUtil;
import org.codelibs.core.misc.AssertionUtil;
import org.codelibs.core.misc.DisposableUtil;

public abstract class BeanDescFactory {
    private static volatile boolean initialized;
    private static final ConcurrentMap<Class<?>, BeanDesc> beanDescCache;

    public static BeanDesc getBeanDesc(Class<?> clazz) {
        BeanDesc beanDesc;
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        if (!initialized) {
            BeanDescFactory.initialize();
        }
        if ((beanDesc = (BeanDesc)beanDescCache.get(clazz)) == null) {
            beanDesc = CollectionsUtil.putIfAbsent(beanDescCache, clazz, new BeanDescImpl(clazz));
        }
        return beanDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        Class<BeanDescFactory> clazz = BeanDescFactory.class;
        synchronized (BeanDescFactory.class) {
            if (!initialized) {
                DisposableUtil.add(() -> BeanDescFactory.clear());
                initialized = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void clear() {
        beanDescCache.clear();
        initialized = false;
    }

    static {
        beanDescCache = CollectionsUtil.newConcurrentHashMap(1024);
        BeanDescFactory.initialize();
    }
}

