/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.beans.converter;

import java.text.DecimalFormat;
import java.text.ParseException;
import org.codelibs.core.beans.Converter;
import org.codelibs.core.exception.ParseRuntimeException;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.misc.AssertionUtil;

public class NumberConverter
implements Converter {
    protected String pattern;

    public NumberConverter(String pattern) {
        AssertionUtil.assertArgumentNotEmpty("pattern", pattern);
        this.pattern = pattern;
    }

    @Override
    public Object getAsObject(String value) {
        if (StringUtil.isEmpty(value)) {
            return null;
        }
        try {
            return new DecimalFormat(this.pattern).parse(value);
        }
        catch (ParseException e) {
            throw new ParseRuntimeException(e);
        }
    }

    @Override
    public String getAsString(Object value) {
        if (value == null) {
            return null;
        }
        return new DecimalFormat(this.pattern).format(value);
    }

    @Override
    public boolean isTarget(Class<?> clazz) {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        return Number.class.isAssignableFrom(clazz);
    }
}

