/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.beans.converter;

import java.util.Date;
import org.codelibs.core.beans.Converter;
import org.codelibs.core.convert.DateConversionUtil;
import org.codelibs.core.convert.StringConversionUtil;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.misc.AssertionUtil;

public class DateConverter
implements Converter {
    protected String pattern;

    public DateConverter(String pattern) {
        AssertionUtil.assertArgumentNotEmpty("pattern", pattern);
        this.pattern = pattern;
    }

    @Override
    public Object getAsObject(String value) {
        if (StringUtil.isEmpty(value)) {
            return null;
        }
        return DateConversionUtil.toDate((Object)value, this.pattern);
    }

    @Override
    public String getAsString(Object value) {
        if (value == null) {
            return null;
        }
        return StringConversionUtil.toString((Date)value, this.pattern);
    }

    @Override
    public boolean isTarget(Class<?> clazz) {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        return clazz == Date.class;
    }
}

