/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.codejargon.fluentjdbc.api.FluentJdbcException;
import org.codejargon.fluentjdbc.api.query.Mapper;
import org.codejargon.fluentjdbc.api.query.UpdateResultGenKeys;
import org.codejargon.fluentjdbc.internal.query.UpdateResultGenKeysInternal;

class FetchGenKey<T> {
    final Optional<Mapper<T>> mapper;

    static FetchGenKey<Void> no() {
        return new FetchGenKey<Void>(Optional.empty());
    }

    static <T> FetchGenKey<T> yes(Mapper<T> mapper) {
        return new FetchGenKey<T>(Optional.of(mapper));
    }

    private FetchGenKey(Optional<Mapper<T>> optional) {
        this.mapper = optional;
    }

    boolean fetch() {
        return this.mapper.isPresent();
    }

    UpdateResultGenKeys<T> genKeys(PreparedStatement preparedStatement, Integer n) throws SQLException {
        List<T> list = this.generatedKeys(preparedStatement);
        if (list.size() != n.intValue()) {
            throw new FluentJdbcException("Can't fetch generated keys properly, does the jdbc driver support it?");
        }
        return new UpdateResultGenKeysInternal<T>((long)n, list);
    }

    private List<T> generatedKeys(PreparedStatement preparedStatement) throws SQLException {
        try (ResultSet resultSet = preparedStatement.getGeneratedKeys();){
            ArrayList<T> arrayList = new ArrayList<T>(1);
            while (resultSet.next()) {
                arrayList.add(this.mapper.get().map(resultSet));
            }
            List list = Collections.unmodifiableList(arrayList);
            return list;
        }
    }
}

