/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.codejargon.fluentjdbc.api.FluentJdbcException;
import org.codejargon.fluentjdbc.api.query.Mapper;
import org.codejargon.fluentjdbc.api.query.SelectQuery;
import org.codejargon.fluentjdbc.api.query.SqlConsumer;
import org.codejargon.fluentjdbc.api.query.SqlErrorHandler;
import org.codejargon.fluentjdbc.internal.query.QueryConfig;
import org.codejargon.fluentjdbc.internal.query.QueryInternal;
import org.codejargon.fluentjdbc.internal.query.SingleQueryBase;
import org.codejargon.fluentjdbc.internal.support.Preconditions;
import org.codejargon.fluentjdbc.internal.support.Predicates;

class SelectQueryInternal
extends SingleQueryBase
implements SelectQuery {
    private Predicate filter = Predicates.alwaysTrue();
    private Optional<Integer> fetchSize = Optional.empty();
    private Optional<Long> maxRows = Optional.empty();

    SelectQueryInternal(String string, QueryInternal queryInternal) {
        super(queryInternal, string);
    }

    @Override
    public <T> SelectQuery filter(Predicate<T> predicate) {
        this.filter = predicate;
        return this;
    }

    @Override
    public SelectQuery fetchSize(Integer n) {
        Preconditions.checkNotNull(n, "rows");
        Preconditions.checkArgument(n >= 0, "Fetch size rows must be >= 0");
        this.fetchSize = Optional.of(n);
        return this;
    }

    @Override
    public SelectQuery maxRows(Long l) {
        Preconditions.checkNotNull(l, "rows");
        Preconditions.checkArgument(l >= 0L, "Max results rows must be >= 0");
        this.maxRows = Optional.of(l);
        return this;
    }

    @Override
    public SelectQuery params(List<?> list) {
        this.addParameters(list);
        return this;
    }

    @Override
    public SelectQuery params(Object ... objectArray) {
        this.addParameters(objectArray);
        return this;
    }

    @Override
    public SelectQuery namedParams(Map<String, ?> map) {
        this.addNamedParameters(map);
        return this;
    }

    @Override
    public SelectQuery namedParam(String string, Object object) {
        this.addNamedParameter(string, object);
        return this;
    }

    @Override
    public SelectQuery errorHandler(SqlErrorHandler sqlErrorHandler) {
        this.sqlErrorHandler = sqlErrorHandler;
        return this;
    }

    @Override
    public <T> Optional<T> firstResult(Mapper<T> mapper) {
        return this.runQuery(preparedStatement -> {
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                Optional optional;
                Optional<Object> optional2 = Optional.empty();
                while (resultSet.next() && !optional2.isPresent()) {
                    optional = mapper.map(resultSet);
                    if (!this.filter.test(optional)) continue;
                    optional2 = Optional.of(optional);
                }
                optional = optional2;
                return optional;
            }
        }, this.sqlErrorHandler);
    }

    @Override
    public <T> T singleResult(Mapper<T> mapper) {
        Optional<T> optional = this.firstResult(mapper);
        if (!optional.isPresent()) {
            throw this.query.queryException(this.sql, Optional.of("At least one result expected"), Optional.empty());
        }
        return optional.get();
    }

    @Override
    public <T> List<T> listResult(Mapper<T> mapper) {
        ArrayList arrayList = new ArrayList();
        this.iterateResult(mapper, arrayList::add);
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public <T> Set<T> setResult(Mapper<T> mapper) {
        HashSet hashSet = new HashSet();
        this.iterateResult(mapper, hashSet::add);
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public <T> void iterateResult(Mapper<T> mapper, Consumer<T> consumer) {
        this.runQuery(preparedStatement -> {
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    Object t = mapper.map(resultSet);
                    if (!this.filter.test(t)) continue;
                    consumer.accept(t);
                }
            }
            return null;
        }, this.sqlErrorHandler);
    }

    @Override
    public void iterateResult(SqlConsumer<ResultSet> sqlConsumer) {
        this.runQuery(preparedStatement -> {
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    if (!this.filter.test(resultSet)) continue;
                    sqlConsumer.accept(resultSet);
                }
            }
            return null;
        }, this.sqlErrorHandler);
    }

    @Override
    void customizeQuery(PreparedStatement preparedStatement, QueryConfig queryConfig) throws SQLException {
        this.selectFetchSize(preparedStatement, queryConfig);
        this.maxResults(preparedStatement);
    }

    private void selectFetchSize(PreparedStatement preparedStatement, QueryConfig queryConfig) throws SQLException {
        Optional<Integer> optional = queryConfig.fetchSize(this.fetchSize);
        if (optional.isPresent()) {
            preparedStatement.setFetchSize(optional.get());
        }
    }

    private void maxResults(PreparedStatement preparedStatement) throws SQLException {
        if (this.maxRows.isPresent()) {
            if (this.maxRows.get() > Integer.MAX_VALUE) {
                this.setLargeMaxRows(preparedStatement);
            } else {
                preparedStatement.setMaxRows((int)this.maxRows.get().longValue());
            }
        }
    }

    private void setLargeMaxRows(PreparedStatement preparedStatement) throws SQLException {
        try {
            preparedStatement.setLargeMaxRows(this.maxRows.get());
        }
        catch (SQLException sQLException) {
            throw new FluentJdbcException(String.format("The JDBC driver %s doesn't support setLargeMaxRows(). Set max results <= Integer.MAX_VALUE", preparedStatement.getConnection().getMetaData().getDriverName()));
        }
    }
}

