/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.api.mapper;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.codejargon.fluentjdbc.api.mapper.ObjectMapperRsExtractor;
import org.codejargon.fluentjdbc.api.query.Mapper;
import org.codejargon.fluentjdbc.internal.mappers.DefaultObjectMapperRsExtractors;
import org.codejargon.fluentjdbc.internal.mappers.ObjectMapper;
import org.codejargon.fluentjdbc.internal.support.Maps;

public class ObjectMappers {
    private final Map<Class, ObjectMapperRsExtractor> extractors;
    private final Map<Class, Mapper<?>> mappers;
    private final Function<String, String> converter;

    private ObjectMappers(Map<Class, ObjectMapperRsExtractor> map, Function<String, String> function) {
        this.extractors = Maps.merge(DefaultObjectMapperRsExtractors.extractors(), map);
        this.converter = function;
        this.mappers = new ConcurrentHashMap();
    }

    public <T> Mapper<T> forClass(Class<T> clazz2) {
        return this.mappers.computeIfAbsent(clazz2, clazz -> new ObjectMapper(clazz, this.extractors, this.converter));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<Class, ObjectMapperRsExtractor> extractors = Collections.emptyMap();
        private Function<String, String> converter = string -> string.toLowerCase().replace("_", "");

        private Builder() {
        }

        public Builder extractors(Map<Class, ObjectMapperRsExtractor> map) {
            this.extractors = Maps.copyOf(map);
            return this;
        }

        public Builder fieldNameConverter(Function<String, String> function) {
            this.converter = function;
            return this;
        }

        public ObjectMappers build() {
            return new ObjectMappers(Maps.copyOf(this.extractors), this.converter);
        }
    }
}

