/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.mappers;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.codejargon.fluentjdbc.api.FluentJdbcException;
import org.codejargon.fluentjdbc.api.mapper.ObjectMapperRsExtractor;
import org.codejargon.fluentjdbc.api.query.Mapper;
import org.codejargon.fluentjdbc.internal.support.Arrs;
import org.codejargon.fluentjdbc.internal.support.Maps;

public class ObjectMapper<T>
implements Mapper<T> {
    private final Map<Class, ObjectMapperRsExtractor> extractors;
    private final Class<T> type;
    private final Map<String, Field> fields;
    private final Constructor<T> noargConstructor;

    public ObjectMapper(Class<T> clazz, Map<Class, ObjectMapperRsExtractor> map) {
        this.extractors = map;
        this.type = clazz;
        this.fields = this.discoverFields(clazz);
        this.noargConstructor = this.noargConstructor();
    }

    private Map<String, Field> discoverFields(Class<T> clazz) throws SecurityException {
        HashMap hashMap = new HashMap();
        for (Class<T> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Arrs.stream(clazz2.getDeclaredFields()).forEach(field -> {
                field.setAccessible(true);
                hashMap.put(this.prepareFieldName(field.getName()), field);
            });
        }
        return Maps.copyOf(hashMap);
    }

    @Override
    public T map(ResultSet resultSet) throws SQLException {
        T t = this.newInstance();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            this.mapColumn(this.fieldName(resultSetMetaData, i), i, resultSet, t);
        }
        return t;
    }

    private void mapColumn(String string, int n, ResultSet resultSet, T t) throws IllegalArgumentException, FluentJdbcException, SQLException {
        Field field = this.fields.get(string);
        if (field != null) {
            Object object = this.value(field.getType(), resultSet, n);
            this.setField(field, t, object);
        }
    }

    private void setField(Field field, T t, Object object) {
        try {
            field.set(t, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new FluentJdbcException(String.format("Unable to set field %s in %s with value %s", field.getName(), field.getDeclaringClass(), object != null ? object.getClass().getName() : "null"), illegalAccessException);
        }
    }

    private Object value(Class clazz, ResultSet resultSet, Integer n) throws SQLException {
        ObjectMapperRsExtractor objectMapperRsExtractor = this.extractors.get(clazz);
        Object object = objectMapperRsExtractor != null ? objectMapperRsExtractor.extract(resultSet, n) : resultSet.getObject(n);
        return resultSet.wasNull() && !clazz.isPrimitive() ? null : object;
    }

    private T newInstance() throws IllegalArgumentException {
        try {
            return this.noargConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            throw new FluentJdbcException(String.format("Cannot instantiate %s with the no-arg constructor", this.type.getName()), reflectiveOperationException);
        }
    }

    private Constructor<T> noargConstructor() {
        try {
            Constructor<T> constructor = this.type.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new FluentJdbcException(String.format("Cannot find no-arg constructor in %s", this.type.getName()), noSuchMethodException);
        }
    }

    private String fieldName(ResultSetMetaData resultSetMetaData, int n) throws SQLException {
        return this.prepareFieldName(resultSetMetaData.getColumnLabel(n));
    }

    private String prepareFieldName(String string) {
        return string.toLowerCase().replace("_", "");
    }
}

