/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.codejargon.fluentjdbc.api.FluentJdbcSqlException;
import org.codejargon.fluentjdbc.api.ParamSetter;

class ParamAssigner {
    private static final ParamSetter fallbackParamSetter = (object, preparedStatement, n) -> {
        if (!object.getClass().isEnum()) {
            preparedStatement.setObject(n, object);
        } else {
            preparedStatement.setString(n, object.toString());
        }
    };
    private final Map<Class, ParamSetter> paramSetters;

    ParamAssigner(Map<Class, ParamSetter> map) {
        this.paramSetters = map;
    }

    void assignParams(PreparedStatement preparedStatement, List<?> list) {
        int n = 1;
        for (Object obj : list) {
            this.assignParam(preparedStatement, n, obj);
            ++n;
        }
    }

    private void assignParam(PreparedStatement preparedStatement, Integer n, Object object) {
        try {
            if (object != null) {
                this.assignNonNull(object, preparedStatement, n);
            } else {
                this.assignNull(preparedStatement, n);
            }
        }
        catch (SQLException sQLException) {
            throw new FluentJdbcSqlException(String.format("Error assigning parameter index %s, object %s", n, object != null ? object.getClass().getName() : "null"), sQLException);
        }
    }

    private void assignNull(PreparedStatement preparedStatement, Integer n) throws SQLException {
        Integer n2;
        try {
            n2 = preparedStatement.getParameterMetaData().getParameterType(n);
        }
        catch (SQLException sQLException) {
            throw new FluentJdbcSqlException("Can't access parameter metadata, JDBC 3.0 not supported by the driver.", sQLException);
        }
        preparedStatement.setNull(n, n2);
    }

    private void assignNonNull(Object object, PreparedStatement preparedStatement, Integer n) throws SQLException {
        this.paramSetter(object).set(object, preparedStatement, n);
    }

    private ParamSetter paramSetter(Object object) {
        ParamSetter paramSetter = this.paramSetters.get(object.getClass());
        return paramSetter != null ? paramSetter : fallbackParamSetter;
    }
}

