/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.codejargon.fluentjdbc.api.FluentJdbc;
import org.codejargon.fluentjdbc.api.ParamSetter;
import org.codejargon.fluentjdbc.api.integration.ConnectionProvider;
import org.codejargon.fluentjdbc.api.integration.providers.DataSourceConnectionProvider;
import org.codejargon.fluentjdbc.internal.FluentJdbcInternal;
import org.codejargon.fluentjdbc.internal.support.Maps;
import org.codejargon.fluentjdbc.internal.support.Preconditions;

public class FluentJdbcBuilder {
    private Optional<Integer> defaultFetchSize = Optional.empty();
    private Optional<ConnectionProvider> connectionProvider = Optional.empty();
    private Map<Class, ParamSetter> paramSetters = Maps.copyOf(new HashMap());

    public FluentJdbcBuilder connectionProvider(ConnectionProvider connectionProvider) {
        Preconditions.checkNotNull(connectionProvider, "connectionProvider");
        this.connectionProvider = Optional.of(connectionProvider);
        return this;
    }

    public FluentJdbcBuilder connectionProvider(DataSource dataSource) {
        return this.connectionProvider(new DataSourceConnectionProvider(dataSource));
    }

    public FluentJdbcBuilder paramSetters(Map<Class, ParamSetter> map) {
        Preconditions.checkNotNull(map, "paramSetters");
        this.paramSetters = map;
        return this;
    }

    public FluentJdbcBuilder defaultFetchSize(Integer n) {
        Preconditions.checkNotNull(n, "rows");
        Preconditions.checkArgument(n >= 0, "Fetch size rows must be >= 0");
        this.defaultFetchSize = Optional.of(n);
        return this;
    }

    public FluentJdbc build() {
        return new FluentJdbcInternal(this.connectionProvider, Maps.copyOf(this.paramSetters), this.defaultFetchSize);
    }
}

