/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.codejargon.fluentjdbc.api.FluentJdbc;
import org.codejargon.fluentjdbc.api.ParamSetter;
import org.codejargon.fluentjdbc.api.integration.ConnectionProvider;
import org.codejargon.fluentjdbc.internal.FluentJdbcInternal;
import org.codejargon.fluentjdbc.internal.support.Maps;
import org.codejargon.fluentjdbc.internal.support.Preconditions;

public class FluentJdbcBuilder {
    private Optional<Integer> defaultFetchSize = Optional.empty();
    private Optional<ConnectionProvider> connectionProvider = Optional.empty();
    private Map<Class, ParamSetter> paramSetters = Maps.copyOf(new HashMap());

    public FluentJdbcBuilder connectionProvider(ConnectionProvider connectionProvider) {
        Preconditions.checkNotNull(connectionProvider, "connnectionProvider");
        this.connectionProvider = Optional.of(connectionProvider);
        return this;
    }

    public FluentJdbcBuilder paramSetters(Map<Class, ParamSetter> paramSetters) {
        Preconditions.checkNotNull(paramSetters, "paramSetters");
        this.paramSetters = paramSetters;
        return this;
    }

    public FluentJdbcBuilder defaultFetchSize(Integer rows) {
        Preconditions.checkNotNull(rows, "rows");
        Preconditions.checkArgument(rows >= 0, "Fetch size rows must be >= 0");
        this.defaultFetchSize = Optional.of(rows);
        return this;
    }

    public FluentJdbc build() {
        return new FluentJdbcInternal(this.connectionProvider, Maps.copyOf(this.paramSetters), this.defaultFetchSize);
    }
}

