/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.api.integration.guicepersist.standalone;

import com.google.inject.persist.Transactional;
import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.codejargon.fluentjdbc.api.integration.guicepersist.standalone.StandaloneTxConnectionProvider;
import org.codejargon.fluentjdbc.internal.support.FindFirst;
import org.codejargon.fluentjdbc.internal.support.Lists;

class TransactionInterceptor
implements MethodInterceptor {
    private final StandaloneTxConnectionProvider standaloneTxConnectionProvider;

    TransactionInterceptor(StandaloneTxConnectionProvider standaloneTxConnectionProvider) {
        this.standaloneTxConnectionProvider = standaloneTxConnectionProvider;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Boolean newTransactionStarted = this.startNewTransactionIfNecessary();
        try {
            Object object = this.invokeMethodAndCommitIfNecessary(methodInvocation, newTransactionStarted);
            return object;
        }
        catch (Exception e) {
            this.rollbackOrCommit(methodInvocation, e);
            throw e;
        }
        finally {
            if (newTransactionStarted.booleanValue()) {
                this.standaloneTxConnectionProvider.removeActiveTransactionConnection();
            }
        }
    }

    private Object invokeMethodAndCommitIfNecessary(MethodInvocation methodInvocation, Boolean newTransactionStarted) throws Throwable {
        Object result = methodInvocation.proceed();
        if (newTransactionStarted.booleanValue()) {
            this.standaloneTxConnectionProvider.commitActiveTransaction();
        }
        return result;
    }

    private Boolean startNewTransactionIfNecessary() {
        Boolean newTransactionStarted;
        if (!this.standaloneTxConnectionProvider.hasActiveTransaction().booleanValue()) {
            this.standaloneTxConnectionProvider.startNewTransaction();
            newTransactionStarted = true;
        } else {
            newTransactionStarted = false;
        }
        return newTransactionStarted;
    }

    private void rollbackOrCommit(MethodInvocation methodInvocation, Exception e) {
        if (this.rollbackNecessary(e, this.transactional(methodInvocation))) {
            this.standaloneTxConnectionProvider.rollbackActiveTransaction();
        } else {
            this.standaloneTxConnectionProvider.commitActiveTransaction();
        }
    }

    private Transactional transactional(MethodInvocation methodInvocation) {
        return (Transactional)FindFirst.fromLazy((Supplier[])new Supplier[]{() -> methodInvocation.getMethod().getAnnotation(Transactional.class), () -> methodInvocation.getThis().getClass().getAnnotation(Transactional.class), this::defaultTransactional}).whichIsNotNull().get();
    }

    private boolean rollbackNecessary(Exception cause, Transactional transactional) {
        return this.has(transactional.rollbackOn(), cause) != false && this.has(transactional.ignore(), cause) == false;
    }

    private Boolean has(Class<? extends Exception>[] exceptions, Exception cause) {
        return Lists.copyOf((Object[])exceptions).stream().filter(e -> e.isInstance(cause)).findAny().isPresent();
    }

    private Transactional defaultTransactional() {
        return DefaultTransactionalDummy.class.getAnnotation(Transactional.class);
    }

    @Transactional
    private static class DefaultTransactionalDummy {
        private DefaultTransactionalDummy() {
        }
    }
}

